/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.screen.content.banner;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.gui.screen.content.banner.AdvHelper;
import ru.softlogic.gui.screen.content.banner.BannerManagerTask;
import ru.softlogic.reference.adv.AdvStatisticType;
import ru.softlogic.system.util.ThreadUtil;

public class BannerManager {
    private static BannerManager manager = new BannerManager();
    private final Thread rotatorThread;
    private LinkedList<BannerManagerTask> tasks = new LinkedList();
    private LinkedList<Runnable> stopMediaPlayersCallback = new LinkedList();

    public BannerManager() {
        this.rotatorThread = new Thread(new Rotator());
        this.rotatorThread.setDaemon(true);
        this.rotatorThread.start();
    }

    public static BannerManager getInstance() {
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(BannerManagerTask task) {
        LinkedList<BannerManagerTask> linkedList = this.tasks;
        synchronized (linkedList) {
            this.tasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStopMediaPlayerCallback(Runnable run) {
        LinkedList<BannerManagerTask> linkedList = this.tasks;
        synchronized (linkedList) {
            this.stopMediaPlayersCallback.add(run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LinkedList<BannerManagerTask> linkedList = this.tasks;
        synchronized (linkedList) {
            if (!this.stopMediaPlayersCallback.isEmpty()) {
                Iterator i = this.stopMediaPlayersCallback.iterator();
                while (i.hasNext()) {
                    Runnable r = (Runnable)i.next();
                    r.run();
                    i.remove();
                }
            }
            this.tasks.clear();
        }
    }

    private class Rotator
    implements Runnable {
        private Rotator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                LinkedList linkedList = BannerManager.this.tasks;
                synchronized (linkedList) {
                    Iterator iterator = BannerManager.this.tasks.iterator();
                    while (iterator.hasNext()) {
                        final BannerManagerTask task = (BannerManagerTask)iterator.next();
                        if (task.getShowTime() >= System.currentTimeMillis() - task.getStartTime()) continue;
                        if (task.getCallback() != null) {
                            task.getCallback().run();
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LinkedList<Integer> bi = new LinkedList<Integer>();
                                    AdvHelper.getImageBanner(task.getPanel(), task.getService(), task.getPlace(), task.getWidth(), task.getHeight(), task.getListener(), null, bi, false);
                                    AppEnvironment.getInstance().addAdvEvent(bi, AdvStatisticType.BannerShow);
                                }
                            });
                        }
                        iterator.remove();
                    }
                }
                ThreadUtil.sleep((long)1000L);
            }
        }
    }
}

