/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.components.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.border.Border;
import ru.softlogic.gui.components.border.CurvedBorder;
import ru.softlogic.gui.utils.ScreenUtil;

public class RoundCornerPanel
extends JPanel {
    public RoundCornerPanel(Color color) {
        this(color, Color.BLACK, Color.LIGHT_GRAY);
    }

    public RoundCornerPanel(Color background, Color border, Color gradient) {
        if (background == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 background");
        }
        int width = (int)(ScreenUtil.getScreenSize().getWidth() * 70.0 / 100.0);
        int height = (int)(ScreenUtil.getScreenSize().getHeight() * 60.0 / 100.0);
        Dimension size = new Dimension(width, height);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
        this.setSize(size);
        this.setBorder(new CurvedBorder(border, gradient, 5));
        this.setBackground(background);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Border border = this.getBorder();
        if (border == null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (border instanceof CurvedBorder) {
            CurvedBorder cb = (CurvedBorder)border;
            int sz = cb.getSinkLevel();
            g.setColor(this.getBackground());
            g.fillRoundRect(sz / 2, sz / 2, this.getWidth() - sz, this.getHeight() - sz, cb.getRadius(), cb.getRadius());
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

