/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.components.button;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import ru.softlogic.gui.components.button.ClickButton;

public class IconifiedLabeledClickButton
extends ClickButton {
    private JLabel icoPanel;
    private JLabel textlabel;
    private boolean onButton;
    private String pos = "c,c";
    private Font noLogoFont;
    private Font wLogoFont;
    private double marginH;
    private double marginW;

    public IconifiedLabeledClickButton() {
        this(0.0, 0.0, 0.0, 0.0, "c,c");
    }

    public IconifiedLabeledClickButton(boolean onButton) {
        this(0.0, 0.0, 0.0, 0.0, "c,c");
        this.onButton = onButton;
    }

    public IconifiedLabeledClickButton(double top, double bottom) {
        this(top, bottom, 0.0, 0.0, "c,c");
    }

    public IconifiedLabeledClickButton(double top, double bottom, double left, double right) {
        this(top, bottom, left, right, "c,c");
    }

    public IconifiedLabeledClickButton(double top, double bottom, double left, double right, String position) {
        this.pos = position;
        this.marginH = top + bottom + 5.0;
        this.marginW = left + right;
        this.icoPanel = new JLabel();
        this.textlabel = new JLabel();
        this.setLayout((LayoutManager)new TableLayout(new double[]{left, -1.0, right}, new double[]{top, -1.0, -1.0, 5.0, -1.0, bottom}));
        this.add((Component)this.icoPanel, "1,1,1,2," + this.pos);
        this.add((Component)this.textlabel, "1,4,1,1," + this.pos);
    }

    public boolean isOnButton() {
        return this.onButton;
    }

    public void setOnButton(boolean onButton) {
        this.onButton = onButton;
    }

    public JLabel getTextLabel() {
        return this.textlabel;
    }

    public int getWidthWOMargins() {
        return this.getSize().width - (int)this.marginW;
    }

    public void setLogo(Icon icon) {
        Icon scaledIcon = null;
        if (icon == null) {
            this.remove(this.textlabel);
            this.setFont(this.noLogoFont);
            this.add((Component)this.textlabel, "1,1,1,4," + this.pos);
        } else {
            this.remove(this.textlabel);
            this.setFont(this.wLogoFont);
            this.add((Component)this.textlabel, "1,4,1,1," + this.pos);
            scaledIcon = this.scaleIconToIcoPaneSize(icon);
        }
        this.icoPanel.setIcon(scaledIcon);
    }

    public boolean isLogoSetted() {
        return this.icoPanel.getIcon() != null;
    }

    @Override
    public void setText(String text) {
        if (this.onButton) {
            super.setText(text);
        }
        if (this.textlabel != null) {
            this.textlabel.setText(text);
        }
        this.setSymbol(text);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.textlabel.setEnabled(b);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.textlabel != null) {
            this.textlabel.setFont(font);
        }
    }

    public void setNoLogoFont(Font font) {
        this.noLogoFont = font;
    }

    public void setWLogoFont(Font font) {
        this.wLogoFont = font;
    }

    private Icon scaleIconToIcoPaneSize(Icon icon) {
        ImageIcon scaledIcon = null;
        if (icon instanceof ImageIcon) {
            Image img = ((ImageIcon)icon).getImage();
            int scaledH = (int)(((double)this.getPreferredSize().height - this.marginH) * 0.66);
            int scaledW = (int)((float)scaledH / (float)icon.getIconHeight() * (float)icon.getIconWidth());
            if (scaledW > (int)((double)this.getPreferredSize().width - this.marginW)) {
                scaledW = (int)((double)this.getPreferredSize().width - this.marginW);
                scaledH = (int)((float)scaledW / (float)icon.getIconWidth() * (float)icon.getIconHeight());
            }
            scaledIcon = new ImageIcon(img.getScaledInstance(scaledW, scaledH, 16));
        }
        return scaledIcon;
    }
}

