/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.components.button;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.media.MediaPlayer;

public class ClickButton
extends JButton {
    private int pressTime;
    private String symbol;

    public ClickButton() {
        this("");
    }

    public ClickButton(String text) {
        this(text, text, 40);
    }

    public ClickButton(String text, String symbol) {
        this(text, symbol, 40);
    }

    public ClickButton(int pressTime) {
        this("", "", pressTime);
    }

    public ClickButton(String text, String symbol, int pressTime) {
        super(text);
        this.pressTime = pressTime;
        this.symbol = symbol;
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(false);
        this.setRequestFocusEnabled(false);
        this.setFocusable(false);
        this.setMargin(new Insets(-3, -3, -3, -3));
        this.setHorizontalTextPosition(0);
        this.addMouseListener(new ClickButtonMouseListener());
    }

    public int getPressTime() {
        return this.pressTime;
    }

    public void setPressTime(int pressTime) {
        this.pressTime = pressTime;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        UserAction.getInstance().update();
        super.fireActionPerformed(event);
    }

    private class ClickButtonMouseListener
    extends MouseAdapter {
        private ClickButtonMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            MediaPlayer.getInstance().play("_click.mp3");
            ClickButton.this.doClick(ClickButton.this.pressTime);
        }
    }
}

