/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.components.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import ru.softlogic.gui.GuiOptions;
import ru.softlogic.gui.Rendering;

public class LineBorder
extends javax.swing.border.LineBorder {
    private Color gradientColor;

    public LineBorder(Color color, int thickness) {
        this(color, null, thickness);
    }

    public LineBorder(Color color, Color gradientColor, int thickness) {
        super(color, thickness);
        this.gradientColor = gradientColor;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        super.paintBorder(c, g, x, y, w, h);
        if (this.gradientColor != null && !this.gradientColor.equals(this.getLineColor()) && GuiOptions.getRendering() == Rendering.Quality) {
            int dh = (int)((double)h * 0.1);
            int dw = -((int)((double)w * 0.1));
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new GradientPaint(0.0f, h / 2 - h / 4 + dh, this.getLineColor(), 0.0f, h / 2 + dh, this.gradientColor));
            g.fillRect(0, h / 2 - h / 4 + dh, this.getThickness(), h / 4);
            g2d.setPaint(new GradientPaint(0.0f, h / 2 + dh, this.gradientColor, 0.0f, h / 2 + h / 4 + dh, this.getLineColor()));
            g.fillRect(0, h / 2 + dh, this.getThickness(), h / 4);
            g2d.setPaint(new GradientPaint(w / 2 - w / 4 + dw, 0.0f, this.getLineColor(), w / 2 + dw, 0.0f, this.gradientColor));
            g.fillRect(w / 2 - w / 4 + dw, 0, w / 4, this.getThickness());
            g2d.setPaint(new GradientPaint(w / 2 + dw, 0.0f, this.gradientColor, w / 2 + w / 4 + dw, 0.0f, this.getLineColor()));
            g.fillRect(w / 2 + dw, 0, w / 4, this.getThickness());
        }
    }
}

