/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.components.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import ru.softlogic.gui.GuiOptions;
import ru.softlogic.gui.Rendering;

public class CurvedBorder
extends AbstractBorder {
    private Color wallColor = Color.WHITE;
    private Color gradientColor;
    private int thick = 10;
    private int radius = 30;

    public CurvedBorder(Color wall) {
        this.wallColor = wall;
    }

    public CurvedBorder(Color wall, int thick) {
        this(wall, null, thick);
    }

    public CurvedBorder(Color wall, Color gradientColor, int thick) {
        if (this.wallColor != null) {
            this.wallColor = wall;
        }
        this.gradientColor = gradientColor;
        this.thick = thick;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        g.setColor(this.getWallColor());
        for (int i = 0; i < this.thick; ++i) {
            g.drawRoundRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1, this.radius - i, this.radius);
            g.drawRoundRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1, this.radius - i * 2, this.radius);
            g.drawRoundRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1, this.radius, this.radius - i);
            g.drawRoundRect(x + i, y + i, w - i * 2 - 1, h - i * 2 - 1, this.radius, this.radius - i * 2);
            g.drawRoundRect(x + i, y, w - i * 2 - 1, h - 1, this.radius, this.radius);
            g.drawRoundRect(x, y + i, w - 1, h - i * 2 - 1, this.radius, this.radius);
        }
        if (this.gradientColor != null && !this.gradientColor.equals(this.wallColor) && GuiOptions.getRendering() == Rendering.Quality) {
            int dh = (int)((double)h * 0.1);
            int dw = -((int)((double)w * 0.1));
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(new GradientPaint(0.0f, h / 2 - h / 4 + dh, this.wallColor, 0.0f, h / 2 + dh, this.gradientColor));
            g.fillRect(0, h / 2 - h / 4 + dh, this.thick, h / 4);
            g2d.setPaint(new GradientPaint(0.0f, h / 2 + dh, this.gradientColor, 0.0f, h / 2 + h / 4 + dh, this.wallColor));
            g.fillRect(0, h / 2 + dh, this.thick, h / 4);
            g2d.setPaint(new GradientPaint(w / 2 - w / 4 + dw, 0.0f, this.wallColor, w / 2 + dw, 0.0f, this.gradientColor));
            g.fillRect(w / 2 - w / 4 + dw, 0, w / 4, this.thick);
            g2d.setPaint(new GradientPaint(w / 2 + dw, 0.0f, this.gradientColor, w / 2 + w / 4 + dw, 0.0f, this.wallColor));
            g.fillRect(w / 2 + dw, 0, w / 4, this.thick);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.thick, this.thick, this.thick, this.thick);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets i) {
        i.bottom = i.top = this.thick;
        i.right = i.top;
        i.left = i.top;
        return i;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public int getSinkLevel() {
        return this.thick;
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public int getRadius() {
        return this.radius;
    }
}

