/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import ru.softlogic.gui.GuiOptions;
import ru.softlogic.gui.Rendering;
import ru.softlogic.gui.factory.ComponentFactory;

public class ImagePanel
extends JPanel {
    private Image image;
    private boolean managed;

    public ImagePanel() {
        this((Image)null, false);
    }

    public ImagePanel(Image image, boolean managed) {
        this.setImage(image, managed);
        this.setBounds(0, 0, 0, 0);
    }

    public void setImage(Image image, boolean managed) {
        this.image = image;
        this.managed = managed;
        if (image != null) {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            Dimension size = new Dimension(width, height);
            this.setPreferredSize(size);
            this.setSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
        } else {
            this.setPreferredSize(null);
            this.setMinimumSize(null);
            this.setMaximumSize(null);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.managed && GuiOptions.getRendering() == Rendering.Performance && this.image != null) {
            g.setColor(ComponentFactory.getInstance().getBackGroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.image != null) {
            g.drawImage(this.image, 0, 0, null);
        } else {
            super.paintComponent(g);
        }
    }
}

