/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.component;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;

public class FixedLabel
extends JLabel {
    private int maxCount;

    public FixedLabel(Font font, int maxCount) {
        this.setFont(font);
        this.maxCount = maxCount;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.getFont());
        g2d.setBackground(this.getBackground());
        g2d.setColor(this.getForeground());
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int step = this.getWidth() / this.maxCount;
        String text = this.getText() == null ? "" : this.getText();
        FontMetrics fm = g2d.getFontMetrics();
        for (int i = 0; i < this.maxCount && i < text.length(); ++i) {
            g2d.drawString("" + text.charAt(i), step * i, fm.getAscent());
        }
        g2d.dispose();
    }
}

