/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.gui.adv;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.gui.adv.AdvDescription;
import ru.softlogic.gui.adv.BannerComparator;
import ru.softlogic.gui.adv.ContentType;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.system.util.PathUtils;

public class AdvExtractor {
    private boolean isVideoSupported;
    private static AdvExtractor instance = new AdvExtractor();
    private Logger log;
    private Map<String, List<Banner>> playlists = new HashMap<String, List<Banner>>();

    private AdvExtractor() {
        this.log = Logger.getLogger((String)"adv");
        this.log.setAdditivity(false);
        try {
            Class.forName("uk.co.caprica.vlcj.player.MediaPlayer").getConstructors();
            this.isVideoSupported = true;
        }
        catch (Throwable e) {
            this.isVideoSupported = false;
        }
    }

    public static AdvExtractor getInstance() {
        return instance;
    }

    public synchronized AdvDescription extract(String inteface, String place, Integer idService) {
        return this.extract(inteface, place, idService, true);
    }

    public synchronized AdvDescription extract(String inteface, String place, Integer idService, boolean remove) {
        if (inteface == null || place == null) {
            return null;
        }
        List<Banner> banners = this.playlists.get(inteface + "_" + place + "_" + idService);
        if (banners == null || banners.isEmpty()) {
            banners = this.getPlaylist(this.getListByPlace(inteface, place, idService));
            this.playlists.put(inteface + "_" + place + "_" + idService, banners);
        }
        if (banners == null || banners.isEmpty()) {
            return null;
        }
        Banner banner = banners.get(0);
        if (remove) {
            banners.remove(0);
        }
        AdvDescription desc = AdvExtractor.getDescription(banner);
        return desc;
    }

    private static AdvDescription getDescription(Banner banner) {
        AdvDescription description = new AdvDescription();
        description.setBanner(banner);
        if (banner.getUrl().endsWith(".swf")) {
            description.setContentType(ContentType.Flash);
        } else if (banner.getUrl().endsWith(".png")) {
            description.setContentType(ContentType.Image);
        } else if (banner.getUrl().endsWith(".jpg")) {
            description.setContentType(ContentType.Image);
        } else if (banner.getUrl().endsWith(".jpeg")) {
            description.setContentType(ContentType.Image);
        } else if (banner.getUrl().endsWith(".gif")) {
            description.setContentType(ContentType.Image);
        } else if (banner.isVideo() || banner.getUrl().endsWith(".mpg")) {
            description.setContentType(ContentType.Video);
        } else {
            return null;
        }
        description.setPath(PathUtils.getAppHome() + File.separator + "banners" + File.separator + description.getBanner().getUrl());
        return description;
    }

    private List<Banner> getPlaylist(List<Banner> banners) {
        boolean flag;
        if (banners == null || banners.isEmpty()) {
            return null;
        }
        Collections.sort(banners, new BannerComparator());
        LinkedHashMap<Banner, Integer> map = new LinkedHashMap<Banner, Integer>();
        for (Banner banner : banners) {
            map.put(banner, banner.getWeight());
        }
        LinkedList<Banner> result = new LinkedList<Banner>();
        do {
            flag = false;
            for (Banner key : banners) {
                int val = (Integer)map.get(key);
                if (val <= 0) continue;
                flag = true;
                result.add(key);
                map.put(key, val - 1);
            }
        } while (flag);
        return result;
    }

    private List<Banner> getListByPlace(String inteface, String place, Integer idService) {
        String[] split;
        Date now;
        if (inteface == null || place == null) {
            return null;
        }
        Banner[] banners = null;
        try {
            banners = ReferenceManager.getInstance().getBanners();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        if (banners == null || banners.length == 0) {
            return null;
        }
        if (banners.length == 1 && banners[0].getId() == 0) {
            return null;
        }
        LinkedList<Banner> targets = new LinkedList<Banner>();
        block6: for (Banner banner : banners) {
            if (banner.isVideo() && !this.isVideoSupported || !inteface.equals(banner.getIface()) || !place.equals(banner.getPosition()) || banner.getId() <= 0 || !banner.isExclusive()) continue;
            now = new Date();
            if (banner.getBegin() != null && !now.after(banner.getBegin()) || banner.getEnd() != null && !now.before(banner.getEnd())) continue;
            if (idService != null && banner.getServices() != null && !banner.getServices().trim().isEmpty()) {
                for (String num : split = banner.getServices().split(",")) {
                    try {
                        if (!idService.equals(Integer.parseInt(num.trim()))) continue;
                        targets.add(banner);
                        continue block6;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (banner.getIdService() != null && !banner.getIdService().equals(idService)) continue;
            targets.add(banner);
        }
        if (targets.isEmpty()) {
            block8: for (Banner banner : banners) {
                if (banner.isVideo() && !this.isVideoSupported || !inteface.equals(banner.getIface()) || !place.equals(banner.getPosition()) || banner.getId() <= 0) continue;
                now = new Date();
                if (banner.getBegin() != null && !now.after(banner.getBegin()) || banner.getEnd() != null && !now.before(banner.getEnd())) continue;
                if (idService != null && banner.getServices() != null && !banner.getServices().trim().isEmpty()) {
                    for (String num : split = banner.getServices().split(",")) {
                        try {
                            if (!idService.equals(Integer.parseInt(num.trim()))) continue;
                            targets.add(banner);
                            continue block8;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    continue;
                }
                if (banner.getIdService() != null && !banner.getIdService().equals(idService)) continue;
                targets.add(banner);
            }
        }
        return targets;
    }
}

