/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.utils;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionRender;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.CommissionUnit;
import ru.softlogic.skin.kengu24.bundle.kb;

public class CpCommissionRender
extends CommissionRender {
    public static CommissionRender getInstance() {
        if (instance == null) {
            instance = new CpCommissionRender();
        }
        instance.setJarBundle(kb.getJarBundle());
        instance.setBundle(kb.getBundle());
        instance.setLocale(kb.getLocale());
        return instance;
    }

    public String process(Commission commission, Commission serviceCommission, Locale locale, Date startDate, String ps) {
        String res;
        Logger.getLogger((String)"gui").info((Object)("Kengu24.CpCommissionRender.process: commission = " + commission + "; serviceCommission = " + serviceCommission + "; startPay = " + startDate + "; src = " + ps));
        if (commission == null) {
            return "";
        }
        kb.setLocale(locale);
        TreeSet steps = commission.getSteps();
        if (serviceCommission != null && (serviceCommission.getSteps() == null || serviceCommission.getSteps().isEmpty())) {
            CommissionStep firstStep = new CommissionStep(new Sum(0), serviceCommission.getPercentValue(), serviceCommission.getFixedValue());
            String res2 = this.getStepDescription(firstStep);
            StringBuilder sb = new StringBuilder();
            if (res2 != null) {
                sb.append("<b>").append(kb.getString("Screen.std.sum.commval")).append(": ").append(this.getStepDescription(firstStep));
                sb.append("<br/>").append(this.getBounds(commission));
            } else {
                sb.append("<b>").append(kb.getString("Screen.std.sum.nocomm"));
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        CommissionStep firstStep = new CommissionStep(new Sum(0), commission.getPercentValue(), commission.getFixedValue());
        if (steps == null || steps.isEmpty()) {
            res = this.getStepDescription(firstStep);
            String bounds = this.getBounds(commission);
            if (res != null || !bounds.isEmpty()) {
                sb.append("<b>").append(kb.getString("Screen.std.sum.commval")).append(": ").append(res == null ? "0%" : res);
                sb.append("<br/>").append(this.getBounds(commission));
            } else {
                sb.append("<b>").append(kb.getString("Screen.std.sum.nocomm"));
            }
        } else {
            sb.append("<table border=0 cellspacing=0 cellpadding=0><tr><th>").append(kb.getString("Screen.std.sum.income2")).append("&nbsp;&nbsp;</th><th>").append(kb.getString("Screen.std.sum.commission2")).append("</th></tr>");
            res = "";
            if (!((CommissionStep)steps.first()).getSum().isEmpty()) {
                res = this.getStepDescription(firstStep);
                sb.append("<tr><td>").append(kb.getString("Screen.std.sum.from")).append(" ").append(firstStep.getSum()).append("</td><td>").append(res != null ? res : kb.getString("Screen.std.sum.voidcomm")).append("</td></tr>");
            }
            for (CommissionStep step : steps) {
                res = this.getStepDescription(step);
                sb.append("<tr><td>").append(kb.getString("Screen.std.sum.from")).append(" ").append(step.getSum()).append("</td><td>").append(res != null ? res : kb.getString("Screen.std.sum.voidcomm")).append("</td></tr>");
            }
            sb.append("</table><br/>");
            sb.append(this.getBounds(commission));
        }
        HashSet units = commission.getUnits();
        if (units != null && !units.isEmpty()) {
            sb.append("<table border=0 cellspacing=0 cellpadding=0>");
            boolean first = true;
            HashMap<Integer, CashUnit> unitsList = new HashMap<Integer, CashUnit>();
            for (CashUnit cu : CashFactory.getDefaultInstance().getCoinUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            for (CashUnit cu : CashFactory.getDefaultInstance().getCashUnits()) {
                unitsList.put(cu.getId(), cu);
            }
            TreeMap<Sum, Sum> coins = new TreeMap<Sum, Sum>();
            TreeMap<Sum, Sum> notes = new TreeMap<Sum, Sum>();
            Sum prev = null;
            boolean same = true;
            for (CommissionUnit unit : units) {
                if (unit.getFixedValue().getSum() == 0.0) continue;
                CashUnit cu = (CashUnit)unitsList.get(unit.getCashUnit());
                if (cu != null && cu.getType() == 4) {
                    Sum percent = CpCommissionRender.calculatePercent(cu.getNominal(), unit.getFixedValue());
                    coins.put(cu.getNominal(), percent);
                    if (first) {
                        prev = percent;
                        first = false;
                    }
                    if (prev.compareTo(percent) != 0) {
                        same = false;
                    }
                    prev = percent;
                    continue;
                }
                if (cu == null || cu.getType() != 3) continue;
                notes.put(cu.getNominal(), unit.getFixedValue());
            }
            first = true;
            for (Sum nominal : notes.keySet()) {
                if (first) {
                    sb.append("<tr><th>").append(kb.getString("Screen.std.sum.notecomm")).append("</th></tr>");
                    first = false;
                }
                sb.append("<tr><td>").append(nominal).append(" ").append("</td><td>").append(notes.get(nominal)).append("</td></tr>");
            }
            if (same && coins.size() > 1) {
                sb.append("<tr><th>").append(kb.getString("Screen.std.sum.coincomm.same")).append(((Sum)coins.get(coins.firstKey())).getSum()).append("%").append("</th></tr>");
            } else {
                first = true;
                for (Sum nominal : coins.keySet()) {
                    if (first) {
                        sb.append("<tr><th>").append(kb.getString("Screen.std.sum.coincomm")).append("</th></tr>");
                        first = false;
                    }
                    sb.append("<tr><td>").append(nominal).append(" ").append("</td><td>").append(((Sum)coins.get(nominal)).getSum()).append("%").append("</td></tr>");
                }
            }
            sb.append("</table><br/>");
        }
        return sb.toString();
    }

    private static Sum calculatePercent(Sum nominal, Sum fixedValue) {
        return fixedValue.div(nominal.getSum()).mul(100);
    }

    public String getStepDescription(CommissionStep step) {
        String result = "";
        if (step == null) {
            return null;
        }
        result = step.getFixedValue().getSum() > 0.0 && step.getPercentValue() > 0.0 ? MessageFormat.format(kb.getString("Screen.std.comission.screen.step.percentfix"), step.getPercentValue(), step.getFixedValue()) : (step.getPercentValue() > 0.0 ? MessageFormat.format(kb.getString("Screen.std.comission.screen.step.percent"), step.getPercentValue()) : step.getFixedValue().toString());
        if ("0%".equals(result)) {
            result = null;
        }
        return result;
    }
}

