/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.utils;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.gui.adv.AdvDescription;
import ru.softlogic.gui.adv.AdvExtractor;
import ru.softlogic.gui.adv.ContentType;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.screen.content.RedirectListener;
import ru.softlogic.gui.screen.content.banner.BannerManagerTask;
import ru.softlogic.gui.utils.ComponentUtil;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.utils.BannerManager;
import ru.softlogic.skin.kengu24.utils.BannerMouseListener;
import ru.softlogic.skin.kengu24.utils.ButtonHelper;

public class AdvHelper {
    public static JPanel getImageBanner(JPanel target, Service service, String place, int width, int height, RedirectListener listener) {
        AdvDescription description = AdvExtractor.getInstance().extract("Kengu24", place, service != null ? Integer.valueOf(service.getId()) : null);
        if (description == null) {
            return null;
        }
        JPanel targetPanel = target;
        if (targetPanel == null) {
            targetPanel = ComponentUtil.createJPanelBySize((int)width, (int)height);
        } else {
            targetPanel.removeAll();
        }
        JPanel panel = new JPanel();
        if (place.contains("TOP-SERVICE")) {
            panel = AdvHelper.getImageBannerServiceTypeIconPanel(targetPanel, service);
            width = Scaler.x((int)850);
            height = Scaler.y((int)163);
        } else {
            targetPanel.setOpaque(false);
            targetPanel.setLayout(new BorderLayout());
            targetPanel.add(panel);
        }
        if (description != null && description.getContentType() != ContentType.Flash && description.getContentType() == ContentType.Image) {
            if (description.getBanner().getUrl() != null && description.getBanner().getUrl().endsWith(".gif")) {
                panel.setOpaque(false);
                panel.setLayout(new BorderLayout());
                panel.add(new JLabel(BsImageStore.getInstance().getGIFBannerBySize(description.getBanner().getUrl(), width, height)));
                if (listener != null && description.getBanner() != null && (description.getBanner().getIdReferService() != null || description.getBanner().getLabel() != null)) {
                    panel.addMouseListener(new BannerMouseListener(description.getBanner(), listener));
                }
                if (description != null && description.getBanner() != null && description.getBanner().getShowTime() != null) {
                    BannerManager.getInstance().addTask(new BannerManagerTask(System.currentTimeMillis(), (long)(description.getBanner().getShowTime() * 1000), targetPanel, service, place, width, height, listener, null));
                }
                return targetPanel;
            }
            Image image = BsImageStore.getInstance().getBannerBySize(description.getBanner().getUrl(), width, height);
            if (image != null) {
                ImagePanel ip = new ImagePanel(image, false);
                ip.setOpaque(false);
                panel.setOpaque(false);
                panel.setLayout(new BorderLayout());
                panel.add((Component)ip);
                panel.revalidate();
                if (listener != null && description.getBanner() != null && (description.getBanner().getIdReferService() != null || description.getBanner().getLabel() != null)) {
                    ip.addMouseListener((MouseListener)new BannerMouseListener(description.getBanner(), listener));
                }
                if (description != null && description.getBanner() != null && description.getBanner().getShowTime() != null) {
                    BannerManager.getInstance().addTask(new BannerManagerTask(System.currentTimeMillis(), (long)(description.getBanner().getShowTime() * 1000), targetPanel, service, place, width, height, listener, null));
                }
            }
            return targetPanel;
        }
        return null;
    }

    private static JPanel getImageBannerServiceTypeIconPanel(JPanel target, Service service) {
        try {
            JPanel panel = new JPanel();
            panel.setPreferredSize(new Dimension(Scaler.x((int)850), Scaler.y((int)163)));
            panel.setSize(new Dimension(Scaler.x((int)850), Scaler.y((int)163)));
            JPanel parentPanel = target;
            parentPanel.setOpaque(false);
            parentPanel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)57), Scaler.x((int)163), -1.0, Scaler.x((int)850), Scaler.x((int)52)}, new double[]{Scaler.y((int)19), Scaler.y((int)163), Scaler.y((int)18)}));
            ImagePanel logoBGPanel = new ImagePanel(BsImageStore.getInstance().getImage("/buttons/service/group1.png"), false);
            logoBGPanel.setLayout((LayoutManager)new TableLayout(new double[]{Scaler.x((int)163)}, new double[]{Scaler.y((int)163)}));
            ServiceType st = new ServiceType();
            if (service != null) {
                st.setImage(service.getImage());
                st.setName(service.getName());
            }
            JLabel logoLabel = new JLabel();
            ButtonHelper.initSmallImagedLabel(logoLabel, st, new Dimension(Scaler.x((int)163), Scaler.y((int)163)), BsImageStore.imagePrefixS, BsImageStore.imageServicePath);
            logoBGPanel.add((Component)logoLabel, "0,0,c,c");
            parentPanel.add((Component)logoBGPanel, "1,1");
            if (panel != null) {
                parentPanel.add((Component)panel, "3,1,f,f");
            }
            return panel;
        }
        catch (Exception ex) {
            Logger.getLogger((String)"adv").error((Object)ex.getMessage());
            Logger.getLogger((String)"adv").error((Object)Arrays.toString(ex.getStackTrace()));
            return new JPanel();
        }
    }
}

