/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.factory;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.gui.GuiOptions;
import ru.softlogic.gui.bundle.FileControl;
import ru.softlogic.gui.factory.AbstractComponentFactory;
import ru.softlogic.gui.factory.ContentScreenType;
import ru.softlogic.gui.screen.content.ContentScreen;
import ru.softlogic.gui.screen.content.menu.MenuScreen;
import ru.softlogic.gui.screen.popup.cbc.BasePinCodeScreen;
import ru.softlogic.gui.screen.popup.cbc.PinCodePanel;
import ru.softlogic.gui.screen.popup.dialog.BaseDialog;
import ru.softlogic.gui.screen.popup.dialog.DialogPanel;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.advanced.AdvancedBaseDialog;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.screen.shell.Shell;
import ru.softlogic.gui.utils.ImageStore;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.custom.ComplexLockScreen;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.reference.service.Service;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.content.screen.CpComplexLockScreen;
import ru.softlogic.skin.kengu24.content.screen.menu.BsMenuScreen;
import ru.softlogic.skin.kengu24.content.universal.CpCommissionConfirmScreen;
import ru.softlogic.skin.kengu24.content.universal.CpCommonConfirmScreen;
import ru.softlogic.skin.kengu24.content.universal.CpCommonSumScreen;
import ru.softlogic.skin.kengu24.content.universal.CpInfoCommonScreen;
import ru.softlogic.skin.kengu24.content.universal.CpNumericCommonScreen;
import ru.softlogic.skin.kengu24.content.universal.CpSearchProviderScreen;
import ru.softlogic.skin.kengu24.content.universal.CpSelectorCommonScreen;
import ru.softlogic.skin.kengu24.content.universal.CpUniversalCommonScreen;
import ru.softlogic.skin.kengu24.content.universal.PostSaleScreen;
import ru.softlogic.skin.kengu24.popup.dialog.PayoutDialog;
import ru.softlogic.skin.kengu24.popup.panel.BsDialogPanel;
import ru.softlogic.skin.kengu24.popup.panel.BsPinCodePanel;
import ru.softlogic.skin.kengu24.popup.panel.BsWaitScreen;
import ru.softlogic.skin.kengu24.popup.panel.ComissionDialogPanel;
import ru.softlogic.skin.kengu24.popup.panel.KgPayoutPanel;
import ru.softlogic.skin.kengu24.shell.BsShell;
import ru.softlogic.system.util.FontLoader;
import ru.softlogic.system.util.PathUtils;

public class BsComponentFactory
implements AbstractComponentFactory {
    private Logger log = Logger.getLogger((String)"gui");
    private WaitScreen waitScreen;
    private Properties properties;
    private boolean addHotToMax = true;

    public DialogScreen createDialog(DialogType type, String message, int timeout, DisplayedUserCase[] cases, UserCase defaultCase) {
        return new BaseDialog((DialogPanel)new BsDialogPanel(), type, message, timeout, cases, defaultCase);
    }

    public WaitScreen createWaitScreen(String text) {
        if (this.waitScreen == null) {
            this.waitScreen = new BsWaitScreen(text);
        } else {
            this.waitScreen.setText(text);
        }
        return this.waitScreen;
    }

    public WaitScreen createWaitScreen(String type, String text) {
        if (this.waitScreen == null) {
            this.waitScreen = new BsWaitScreen(text);
        } else {
            this.waitScreen.setText(text);
        }
        return this.waitScreen;
    }

    public MenuScreen createMenu() {
        return new BsMenuScreen(this.addHotToMax);
    }

    public Shell createShell() {
        return new BsShell();
    }

    public Color getBackGroundColor() {
        return BsConstants.backGroundColor;
    }

    public String getSkinCode() {
        return "Kengu24";
    }

    public ImageStore getImageStore() {
        return BsImageStore.getInstance("kengu24");
    }

    public ContentScreen createScreen(ContentScreenType type, String param) {
        return null;
    }

    public DialogScreen createDialog(DialogAction action) {
        return new AdvancedBaseDialog((DialogPanel)new BsDialogPanel(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreferences() {
        String folder = "kengu24";
        kb.control = new FileControl(new File(PathUtils.getAppHome(), "/img/kengu24/messages/"));
        FontFactory.getInstance().setRegularFont(this.loadFont("MuseoSansCyrl.ttf"));
        FontFactory.getInstance().setBoldFont(this.loadFont("MuseoSansCyrlBD.ttf"));
        FontFactory.getInstance().setBoldBoldFont(this.loadFont("MuseoSansCyrlBBD.ttf"));
        this.properties = new Properties();
        InputStreamReader isr = null;
        try {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043e\u043f\u0446\u0438\u0438 \u0441\u043a\u0438\u043d\u0430...");
            kb.setLocale(Locale.getDefault());
            isr = new InputStreamReader((InputStream)new FileInputStream(PathUtils.getAppHome() + File.separator + "img" + File.separator + folder + File.separator + "params.properties"), "utf-8");
            this.properties.load(isr);
            this.log.info((Object)"\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e");
            this.addHotToMax = Boolean.parseBoolean(this.properties.getProperty("screen.menu.button.hot.fill", "true"));
            Color color = this.loadColor(this.properties, "color.menu.buttons");
            if (color != null) {
                this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0446\u0432\u0435\u0442 \u043a\u043d\u043e\u043f\u043e\u043a \u043c\u0435\u043d\u044e: " + color));
                BsConstants.textColorMenuButton = color;
            } else {
                this.log.info((Object)"\u0446\u0432\u0435\u0442 \u0442\u0435\u043a\u0441\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043e\u043f\u0446\u0438\u0439.", (Throwable)ex);
        }
        finally {
            try {
                isr.close();
            }
            catch (Exception exception) {}
        }
    }

    public DialogScreen createCompleteDialog(DialogType type, String message, int timeout, DisplayedUserCase[] cases, UserCase defaultCase) {
        return this.createDialog(type, message, timeout, cases, defaultCase);
    }

    public CommonScreen create(String type, String decor) {
        if ("letter".equalsIgnoreCase(type) || type != null && type.toLowerCase().startsWith("group")) {
            return new CpUniversalCommonScreen();
        }
        if ("digital".equalsIgnoreCase(type) || type != null && type.toLowerCase().startsWith("numeric")) {
            return new CpNumericCommonScreen();
        }
        if ("selector".equalsIgnoreCase(type) || type != null && type.toLowerCase().startsWith("selector")) {
            return new CpSelectorCommonScreen();
        }
        if ("info".equalsIgnoreCase(type) || "info-context".equalsIgnoreCase(type)) {
            return new CpInfoCommonScreen();
        }
        if ("sum".equalsIgnoreCase(type) || type != null && type.toLowerCase().startsWith("sum-with-commission-info")) {
            return new CpCommonSumScreen(type.toLowerCase().startsWith("sum-with-commission-info") || "true".equals(this.getPropertyValue("sum-with-commission-info")));
        }
        if ("confirm".equalsIgnoreCase(type) || type != null && type.toLowerCase().startsWith("confirm")) {
            return new CpCommonConfirmScreen();
        }
        if ("commission".equalsIgnoreCase(type)) {
            return new CpCommissionConfirmScreen();
        }
        if ("search-provider".equalsIgnoreCase(type)) {
            return new CpSearchProviderScreen();
        }
        if ("search-provider".equalsIgnoreCase(type)) {
            return new CpSearchProviderScreen();
        }
        if ("print".equalsIgnoreCase(type)) {
            return new PostSaleScreen();
        }
        return null;
    }

    public CustomPanel createDialogPanel(String type) {
        if ("cbc".equals(type)) {
            return new BasePinCodeScreen((PinCodePanel)new BsPinCodePanel());
        }
        if ("commission".equals(type)) {
            return new ComissionDialogPanel();
        }
        return null;
    }

    public ComplexLockScreen createLockScreen() {
        return new CpComplexLockScreen();
    }

    private Font loadFont(String fontName) {
        this.log.info((Object)("Try to load font: " + fontName));
        Font font = FontLoader.fromBasePath((String)fontName);
        this.log.info((Object)(font == null ? "Can't load font" : "Font loaded"));
        if (font == null) {
            throw new NullPointerException("Can't load font");
        }
        boolean reg = GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
        if (reg) {
            this.log.info((Object)"Successfully registered");
        } else {
            this.log.info((Object)"Registration is not successful");
        }
        this.log.info((Object)("Font family: " + font.getFamily()));
        this.log.info((Object)("Font name: " + font.getName()));
        return font;
    }

    public BsComponentFactory() {
        GuiOptions.setSkinFactory((String)"ru.softlogic.skin.kengu24.factory4cp.BsComponentFactory4cp");
        this.getImageStore();
    }

    protected Color loadColor(Properties p, String key) {
        String prop = p.getProperty(key);
        if (prop != null && prop.matches("\\d{1,3},\\d{1,3},\\d{1,3}")) {
            String[] comp = prop.split(",");
            try {
                return new Color(Integer.parseInt(comp[0]), Integer.parseInt(comp[1]), Integer.parseInt(comp[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getPropertyValue(String key) {
        return this.properties.getProperty(key);
    }

    public DialogScreen createPayoutDialog(DialogType type, String message, int timeout, DisplayedUserCase[] cases, UserCase defaultCase, Service service) {
        return new PayoutDialog(new KgPayoutPanel(service), type, message, timeout, cases, defaultCase);
    }
}

