/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.universal.selector;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.gui.screen.menu.MenuButtonHelper;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui2.screen.ComboBoxItem;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.listener.SelectorListener;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.skin.kengu24.BsConstants;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.FontFactory;
import ru.softlogic.skin.kengu24.content.panel.add.CpInfoPanel;
import ru.softlogic.skin.kengu24.content.universal.detail.DetailRender;
import ru.softlogic.skin.kengu24.content.universal.selector.Selector;

public class BsButtonSelector
implements Selector {
    private JPanel panel;
    private ActionListener actionListener;
    private SelectorListener listener;
    private CpInfoPanel infoPanel;
    private ComboBoxItem[] items;
    protected ArrayList<IconifiedClickButton> buttons;
    private Logger log = Logger.getLogger((String)"gui");

    public BsButtonSelector(SelectorListener listener) {
        this.listener = listener;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.actionListener = new SelectListener();
        this.infoPanel = new CpInfoPanel();
    }

    @Override
    public void init(ScreenDescription sd, ScreenInit si, ComboBoxItem[] nItems) {
        try {
            int buttonCount;
            this.panel.setVisible(false);
            this.panel.removeAll();
            this.items = nItems;
            this.buttons = new ArrayList();
            int xCount = buttonCount = this.items.length;
            int yCount = 1;
            if (buttonCount == 4) {
                xCount = 2;
                yCount = 2;
            } else if (buttonCount > 4 && buttonCount <= 6) {
                xCount = 3;
                yCount = 2;
            } else if (buttonCount > 6) {
                xCount = 3;
                yCount = 4;
            }
            double[] widths = new double[xCount * 2 + 1];
            double[] heights = new double[yCount * 2 + 1];
            for (int i = 0; i < xCount * 2 + 1; ++i) {
                if (i == 0 || i == xCount * 2) {
                    widths[i] = -1.0;
                    continue;
                }
                if (i % 2 == 1) {
                    if (buttonCount <= 6) {
                        widths[i] = Scaler.x((int)380);
                        continue;
                    }
                    widths[i] = Scaler.x((int)390);
                    continue;
                }
                widths[i] = buttonCount <= 6 ? (double)Scaler.x((int)30) : (double)Scaler.x((int)15);
            }
            for (int j = 0; j < yCount * 2 + 1; ++j) {
                if (j == 0 || j == yCount * 2) {
                    heights[j] = -1.0;
                    continue;
                }
                if (j % 2 == 1) {
                    if (buttonCount <= 6) {
                        if (buttonCount <= 3) {
                            heights[j] = Scaler.y((int)360);
                            continue;
                        }
                        if (buttonCount <= 3) continue;
                        heights[j] = Scaler.y((int)280);
                        continue;
                    }
                    heights[j] = Scaler.y((int)140);
                    continue;
                }
                if (buttonCount <= 6) {
                    if (buttonCount <= 3) continue;
                    heights[j] = Scaler.y((int)25);
                    continue;
                }
                heights[j] = Scaler.y((int)10);
            }
            this.panel.setLayout((LayoutManager)new TableLayout(widths, heights));
            DetailRender.setTitle(this.infoPanel.getInfo2(), sd, si);
            this.panel.add((Component)this.infoPanel.getPanel(), "0,0," + buttonCount * 2 + ",0");
            int yIndex = 0;
            int xIndex = 0;
            for (int i = 0; i < this.items.length && i < yCount * xCount; ++i) {
                this.buttons.add(this.createButton(this.items[i], yCount, new Dimension((int)widths[xIndex * 2 + 1], (int)heights[yIndex * 2 + 1])));
                this.panel.add((Component)this.buttons.get(i), "" + (xIndex * 2 + 1) + ", " + (yIndex * 2 + 1) + ",c,c");
                if (++xIndex >= xCount) {
                    xIndex = 0;
                    ++yIndex;
                }
                if (yIndex >= yCount) break;
            }
            this.panel.setVisible(true);
        }
        catch (Exception ex) {
            System.out.println(Arrays.toString(ex.getStackTrace()));
            this.log.error((Object)Arrays.toString(ex.getStackTrace()));
        }
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    private IconifiedClickButton createButton(ComboBoxItem cbi, int yCount, Dimension buttonSize) {
        IconifiedClickButton b = null;
        try {
            String imagePostfix = "";
            TableLayout tableLayout = new TableLayout(new double[]{Scaler.y((int)8), -1.0, Scaler.y((int)8)}, new double[]{Scaler.y((int)8), -1.0, Scaler.y((int)8)});
            String iconPosition = "1,1,f,f";
            String textPosition = "1,3,f,f";
            Dimension imageSize = null;
            switch (yCount) {
                case 1: {
                    imagePostfix = BsImageStore.imagePrefixL;
                    imageSize = new Dimension(Scaler.x((int)364), Scaler.y((int)162));
                    tableLayout = new TableLayout(new double[]{Scaler.x((int)8), Scaler.x((int)364), Scaler.x((int)8)}, new double[]{Scaler.y((int)8), Scaler.y((int)162), Scaler.y((int)12), Scaler.y((int)170), Scaler.y((int)8)});
                    break;
                }
                case 2: {
                    imagePostfix = BsImageStore.imagePrefixM;
                    imageSize = new Dimension(Scaler.x((int)364), Scaler.y((int)122));
                    tableLayout = new TableLayout(new double[]{Scaler.x((int)8), Scaler.x((int)364), Scaler.x((int)8)}, new double[]{Scaler.y((int)8), Scaler.y((int)122), Scaler.y((int)0), Scaler.y((int)139), Scaler.y((int)8)});
                    break;
                }
                case 4: {
                    imagePostfix = BsImageStore.imagePrefixS;
                    imageSize = new Dimension(Scaler.x((int)93), Scaler.y((int)126));
                    tableLayout = new TableLayout(new double[]{Scaler.x((int)7), Scaler.x((int)93), Scaler.x((int)7), Scaler.x((int)273), Scaler.x((int)10)}, new double[]{Scaler.y((int)7), Scaler.y((int)126), Scaler.y((int)7)});
                    iconPosition = "1,1,f,f";
                    textPosition = "3,1,f,f";
                    break;
                }
                default: {
                    imagePostfix = "";
                }
            }
            ImageIcon icon = BsImageStore.getInstance().getButtonImageWithSize(BsImageStore.imageServicePath, cbi.getItem().getImage(), imagePostfix, imageSize, false);
            if (icon != null) {
                b = new IconifiedClickButton(icon.getIconWidth(), iconPosition, textPosition, tableLayout);
            } else {
                tableLayout = new TableLayout(new double[]{Scaler.y((int)8), -1.0, Scaler.y((int)8)}, new double[]{Scaler.y((int)8), -1.0, Scaler.y((int)8)});
                iconPosition = "1,1,f,f";
                textPosition = "1,1,f,f";
                b = new IconifiedClickButton(buttonSize.width, iconPosition, textPosition, tableLayout);
                b.getTitleLabel().setSize(buttonSize);
                b.getTitleLabel().setPreferredSize(buttonSize);
            }
            b.getTitleLabel().setHorizontalTextPosition(0);
            b.getTitleLabel().setVerticalTextPosition(0);
            b.getTitleLabel().setHorizontalAlignment(0);
            b.getIconLabel().setHorizontalTextPosition(0);
            b.getIconLabel().setHorizontalAlignment(0);
            b.getIconLabel().setVerticalAlignment(0);
            if (BsImageStore.getInstance().getIcon("/buttons/service/group1.png") != null) {
                b.setIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group1.png"));
                b.setPressedIcon((Icon)BsImageStore.getInstance().getIcon("/buttons/service/group1_press.png"));
            }
            b.getIconLabel().setIcon(icon);
            b.getTitleLabel().setForeground(BsConstants.textColorSelectorButton);
            b.getTitleLabel().setFont(FontFactory.getInstance().createBoldFont("content.selector.button"));
            b.getTitleLabel().setBorder(BorderFactory.createEmptyBorder(0, Scaler.x((int)5), 0, 0));
            String buttonTitle = "";
            if (cbi.getItem() != null && cbi.getItem().getTitle() != null && !cbi.getItem().getTitle().isEmpty()) {
                buttonTitle = cbi.getItem().getTitle();
            } else if (cbi.getItem().getTitle() != null && !cbi.getItem().getTitle().isEmpty()) {
                buttonTitle = cbi.getTitle();
            } else if (cbi.getSelectorTitle() != null && !cbi.getSelectorTitle().isEmpty()) {
                buttonTitle = cbi.getSelectorTitle();
            }
            if (yCount == 4) {
                b.getTitleLabel().setFont(FontFactory.getInstance().createBoldFont("content.selector.button.small"));
                if (!buttonTitle.startsWith("html")) {
                    buttonTitle = "<html><p align='left'>" + buttonTitle;
                }
                b.getTitleLabel().setText(buttonTitle);
                if (icon != null) {
                    b.getTitleLabel().setHorizontalTextPosition(2);
                    b.getTitleLabel().setHorizontalAlignment(2);
                }
            } else if (buttonTitle != null && !buttonTitle.isEmpty()) {
                MenuButtonHelper.setTextOnButton((IconifiedClickButton)b, (String)buttonTitle, (int)Scaler.x((int)364), (Font)b.getTitleLabel().getFont());
            }
            b.setBackground(BsConstants.backColor);
            b.setOpaque(true);
            b.setMultiClickThreshhold(1000L);
            b.setEnabled(cbi.getItem().isEnable());
            b.addActionListener(this.actionListener);
            b.putClientProperty((Object)"item", (Object)cbi);
        }
        catch (Exception ex) {
            System.out.println(Arrays.toString(ex.getStackTrace()));
            this.log.error((Object)Arrays.toString(ex.getStackTrace()));
        }
        return b;
    }

    private class SelectListener
    implements ActionListener {
        private SelectListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            ComboBoxItem cbi = (ComboBoxItem)b.getClientProperty("item");
            BsButtonSelector.this.listener.onSelect(cbi, b);
        }
    }
}

