/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.skin.kengu24.content.screen.menu;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.JPanel;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.gui.component.ImagePanel;
import ru.softlogic.gui.components.button.ClickButton;
import ru.softlogic.gui.components.button.DataButtonListener;
import ru.softlogic.gui.components.button.IconifiedClickButton;
import ru.softlogic.gui.screen.content.RedirectListener;
import ru.softlogic.gui.screen.content.banner.AdvHelper;
import ru.softlogic.gui.screen.content.menu.StateUtil;
import ru.softlogic.gui.screen.menu.LayerData;
import ru.softlogic.gui.screen.menu.MenuLayer;
import ru.softlogic.gui.screen.menu.MenuLayerListener;
import ru.softlogic.gui.screen.menu.listeners.CommonButtonListener;
import ru.softlogic.gui.utils.Scaler;
import ru.softlogic.gui.utils.menu.GroupByLabelVisitor;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.skin.kengu24.BsImageStore;
import ru.softlogic.skin.kengu24.bundle.kb;
import ru.softlogic.skin.kengu24.content.panel.add.CpButtonMenuScreen;
import ru.softlogic.skin.kengu24.content.panel.add.CpInfoPanel;
import ru.softlogic.skin.kengu24.content.screen.menu.ItemComparator;
import ru.softlogic.skin.kengu24.factory.BsButtonFactory;
import ru.softlogic.skin.kengu24.utils.ButtonHelper;

public class DefaultGroupLayer
implements MenuLayer {
    private JPanel main = new ImagePanel(BsImageStore.getInstance().getBackGround("bg"), true);
    private JPanel content;
    private JPanel servicePanel;
    private final JPanel panel;
    private Set<MenuLayerListener> listeners;
    private NaviListener naviListener;
    private LayerData data;
    private LocalGroupListener groupListener;
    private LocalMenuListener menuListener;
    private final CpInfoPanel infoPanel;
    private final CpButtonMenuScreen buttonMenuScreen;
    private IconifiedClickButton[] buttons;
    static int columnCount = 7;
    static int rowCount = 3;

    public DefaultGroupLayer() {
        this.main.setLayout(new BorderLayout());
        this.infoPanel = new CpInfoPanel();
        int smallButtonW = 163;
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.panel.setLayout((LayoutManager)new TableLayout(new double[]{-1.0}, new double[]{Scaler.y((int)200), Scaler.y((int)60), Scaler.y((int)42), -2.0, -1.0, -2.0, Scaler.y((int)24)}));
        this.main.add((Component)this.panel, "Center");
        this.panel.add((Component)this.infoPanel.getPanel(), "0,1");
        this.servicePanel = new JPanel();
        this.servicePanel.setOpaque(false);
        TableLayout tableServiceLayout = new TableLayout(new double[]{-1.0, Scaler.x((int)163), Scaler.x((int)163), Scaler.x((int)163), Scaler.x((int)163), Scaler.x((int)163), Scaler.x((int)163), Scaler.x((int)163), -1.0}, new double[]{Scaler.y((int)163), Scaler.y((int)163), Scaler.y((int)163)});
        tableServiceLayout.setHGap(10);
        tableServiceLayout.setVGap(10);
        this.servicePanel.setLayout((LayoutManager)tableServiceLayout);
        this.panel.add((Component)this.servicePanel, "0,3");
        this.naviListener = new NaviListener();
        this.buttonMenuScreen = new CpButtonMenuScreen(true, false);
        this.buttonMenuScreen.getSearch().addActionListener((ActionListener)new LocalSearchProviderListener());
        this.buttonMenuScreen.getMain().addActionListener((ActionListener)new LocalBackListener());
        this.buttonMenuScreen.getPrev().addActionListener((ActionListener)this.naviListener);
        this.buttonMenuScreen.getNext().addActionListener((ActionListener)this.naviListener);
        this.panel.add((Component)this.buttonMenuScreen.getPanel(), "0,5");
        this.listeners = new HashSet<MenuLayerListener>();
        this.groupListener = new LocalGroupListener();
        this.menuListener = new LocalMenuListener();
    }

    public void initLayer(LayerData data) {
        System.out.println(">>> init Group layer");
        this.data = data;
        kb.setLocale(data.getLocale());
        this.paintLayer(data.getRoot(), 0);
        this.buttonMenuScreen.getMain().setVisible(data.getDeep() > 1);
        this.buttonMenuScreen.getPrev().setText(kb.getString("menu.prev"));
        this.buttonMenuScreen.getMain().setText(kb.getString("menu.exit"));
        this.buttonMenuScreen.getNext().setText(kb.getString("menu.next"));
        LinkedList bi = new LinkedList();
        JPanel bannerPanel = AdvHelper.getImageBanner(null, null, (String)"TOP", (int)Scaler.x((int)1280), (int)Scaler.y((int)200), (RedirectListener)new LocalRedirectListener(), null, bi, (boolean)true);
        if (bannerPanel != null) {
            this.panel.add((Component)bannerPanel, "0,0");
        }
    }

    private void paintLayer(ServiceType parent, int screenNo) {
        String title;
        this.servicePanel.setVisible(false);
        this.servicePanel.removeAll();
        CommonButtonListener cbl = new CommonButtonListener(this.listeners);
        int allButtonsCount = columnCount * rowCount;
        this.buttons = new IconifiedClickButton[allButtonsCount];
        for (int i = 0; i < allButtonsCount; ++i) {
            this.buttons[i] = BsButtonFactory.createSmallServiceButton();
            this.buttons[i].setSize(new Dimension(Scaler.x((int)153), Scaler.y((int)163)));
            this.buttons[i].setPreferredSize(new Dimension(Scaler.x((int)163), Scaler.y((int)163)));
            this.buttons[i].addActionListener((ActionListener)cbl);
            this.servicePanel.add((Component)this.buttons[i], "" + (i % columnCount + 1) + ", " + i / columnCount);
        }
        String string = title = parent.getName() == null || parent.getName().trim().isEmpty() ? parent.getInvitation() : parent.getName();
        if (this.data.getChange() != null && !this.data.getChange().isEmpty()) {
            title = MessageFormat.format(kb.getString("title.change"), this.data.getChange());
        }
        this.infoPanel.getInfo2().setText(title);
        ServiceType[] types = parent.getTypes();
        MenuItem[] items = parent.getMenuItems();
        LinkedList<Object> list = new LinkedList<Object>();
        if (types != null) {
            list.addAll(Arrays.asList(types));
        }
        if (items != null) {
            list.addAll(Arrays.asList(items));
        }
        Collections.sort(list, new ItemComparator());
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            ServiceType st;
            Object obj = it.next();
            if (!(obj instanceof ServiceType) || !(st = (ServiceType)obj).getName().startsWith("#") && !st.getHidden()) continue;
            it.remove();
        }
        this.buttonMenuScreen.getNext().setVisible(false);
        this.buttonMenuScreen.getPrev().setVisible(false);
        int serviceCellsCount = columnCount * rowCount;
        int screenNum = list.size() / serviceCellsCount + (list.size() % serviceCellsCount == 0 ? 0 : 1);
        for (IconifiedClickButton lcb : this.buttons) {
            lcb.setVisible(false);
        }
        if (list.size() > 0) {
            boolean pos = false;
            for (int i = 0; i < serviceCellsCount && i + screenNo * serviceCellsCount < list.size(); ++i) {
                Object obj = list.get(i + screenNo * serviceCellsCount);
                if (obj instanceof ServiceType) {
                    ServiceType st = (ServiceType)obj;
                    ButtonHelper.initSmallServiceButton(this.buttons[i], st);
                    this.buttons[i].setVisible(true);
                    continue;
                }
                if (!(obj instanceof MenuItem)) continue;
                MenuItem mi = (MenuItem)obj;
                MenuItemState mis = StateUtil.getState((MenuItem)mi, (MenuItemState[])this.data.getMenuItemStates());
                ButtonHelper.initSmallServiceButton(this.buttons[i], mi, mis, this.data.getLocale());
                this.buttons[i].setVisible(true);
            }
            if (screenNum > 1) {
                if (screenNo != screenNum - 1) {
                    this.buttonMenuScreen.getNext().putClientProperty((Object)"type", (Object)parent);
                    this.buttonMenuScreen.getNext().putClientProperty((Object)"screen", (Object)new Integer(screenNo + 1));
                    this.buttonMenuScreen.getNext().setVisible(true);
                }
                if (screenNo != 0) {
                    this.buttonMenuScreen.getPrev().putClientProperty((Object)"type", (Object)parent);
                    this.buttonMenuScreen.getPrev().putClientProperty((Object)"screen", (Object)new Integer(screenNo - 1));
                    this.buttonMenuScreen.getPrev().setVisible(true);
                }
            }
        }
        this.servicePanel.setVisible(true);
    }

    public JPanel getPanel() {
        return this.main;
    }

    public void addListener(MenuLayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public String toString() {
        return "DefaultGroupLayer";
    }

    private class LocalRedirectListener
    implements RedirectListener {
        private LocalRedirectListener() {
        }

        public void onRedirect(int serviceId) {
            MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId);
            MenuUtils.processMenu((MenuVisitor)mbsiv);
            MenuItem mi = mbsiv.getMenuItem();
            for (MenuLayerListener mll : DefaultGroupLayer.this.listeners) {
                mll.onMenuItem(mi, null);
            }
        }

        public void toLabel(int label) {
            GroupByLabelVisitor visitor = new GroupByLabelVisitor(label);
            MenuUtils.processMenu((MenuVisitor)visitor);
            if (visitor.getServiceType() != null) {
                for (MenuLayerListener mll : DefaultGroupLayer.this.listeners) {
                    mll.onGroup(visitor.getServiceType());
                }
            }
        }
    }

    private class LocalSearchProviderListener
    implements ActionListener {
        private LocalSearchProviderListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppEnvironment.getInstance().open(ProviderType.SearchService);
        }
    }

    private class NaviListener
    implements ActionListener {
        private NaviListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClickButton navi = (ClickButton)e.getSource();
            ServiceType st = (ServiceType)navi.getClientProperty((Object)"type");
            Integer screen = (Integer)navi.getClientProperty((Object)"screen");
            DefaultGroupLayer.this.paintLayer(st, screen);
        }
    }

    private class LocalMenuListener
    implements DataButtonListener<MenuItem> {
        private LocalMenuListener() {
        }

        public void update(MenuItem data) {
            for (MenuLayerListener mll : DefaultGroupLayer.this.listeners) {
                mll.onMenuItem(data, null);
            }
        }
    }

    private class LocalGroupListener
    implements DataButtonListener<ServiceType> {
        private LocalGroupListener() {
        }

        public void update(ServiceType data) {
            for (MenuLayerListener mll : DefaultGroupLayer.this.listeners) {
                mll.onGroup(data);
            }
        }
    }

    private class LocalBackListener
    implements ActionListener {
        private LocalBackListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MenuLayerListener mll : DefaultGroupLayer.this.listeners) {
                mll.onExit();
            }
        }
    }
}

