/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.fs.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import ru.softlogic.fs.client.CustomHttpClientBuilder;
import ru.softlogic.fs.client.errors.CreateClientException;
import ru.softlogic.fs.client.util.HashUtil;

class RestClient {
    private static final String HEADER_NAME_ID = "X-Auth-Id";
    private static final String HEADER_NAME_HASH = "X-Auth-Hash";
    private static final String HEADER_SERVER_LABEL_NAME = "X-Fserver-Label";
    private static final String SIGN_HASH_SEPARATOR = ":";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final String JSON_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS Z";
    private CloseableHttpClient client;

    public RestClient() throws IOException {
        try {
            this.client = new CustomHttpClientBuilder().build();
        }
        catch (CreateClientException e) {
            throw new IOException(e);
        }
    }

    <T> T postEntity(Class<T> responseType, String url, String method, int id, String apiKey, Map<String, String> params, Object body) throws IOException {
        return this.updateEntity(responseType, url, method, id, apiKey, params, body, (HttpEntityEnclosingRequestBase)new HttpPost());
    }

    <T> T putEntity(Class<T> responseType, String url, String method, int id, String apiKey, Map<String, String> params, Object body) throws IOException {
        return this.updateEntity(responseType, url, method, id, apiKey, params, body, (HttpEntityEnclosingRequestBase)new HttpPut());
    }

    private <T> T updateEntity(Class<T> responseType, String url, String method, int id, String apiKey, Map<String, String> params, Object body, HttpEntityEnclosingRequestBase httpRequest) throws IOException {
        try {
            String methodWithParams = RestClient.buildMethodWithParams(method, params);
            httpRequest.setURI(URI.create(url + methodWithParams));
            Gson gson = new GsonBuilder().setDateFormat(JSON_FORMAT_PATTERN).create();
            String bodyString = gson.toJson(body);
            httpRequest.setEntity((HttpEntity)new ByteArrayEntity(bodyString.getBytes(DEFAULT_CHARSET)));
            RestClient.fillHeaders((HttpRequestBase)httpRequest, methodWithParams, id, apiKey, bodyString);
            return this.executeHttpRequest((HttpRequestBase)httpRequest, responseType);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    <T> T getEntity(Class<T> responseType, String url, String method, int id, String apiKey, Map<String, String> params) throws IOException {
        try {
            String methodWithParams = RestClient.buildMethodWithParams(method, params);
            HttpGet httpRequest = new HttpGet(url + methodWithParams);
            RestClient.fillHeaders((HttpRequestBase)httpRequest, methodWithParams, id, apiKey, "");
            return this.executeHttpRequest((HttpRequestBase)httpRequest, responseType);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static String buildMethodWithParams(String method, Map<String, String> params) throws IOException {
        StringBuilder methodWithParams = new StringBuilder();
        methodWithParams.append(method);
        if (params != null && !params.isEmpty()) {
            try {
                methodWithParams.append('?');
                ArrayList<String> result = new ArrayList<String>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    result.add(entry.getKey() + "=" + (entry.getValue() == null ? "" : URLEncoder.encode(entry.getValue(), DEFAULT_CHARSET.name())));
                }
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj != null) {
                        methodWithParams.append(obj);
                    }
                    if (!iterator.hasNext()) continue;
                    methodWithParams.append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430", e);
            }
        }
        return methodWithParams.toString();
    }

    private static void fillHeaders(HttpRequestBase httpRequest, String methodWithParams, int id, String apiKey, String body) {
        httpRequest.addHeader("Content-Type", "application/json");
        httpRequest.addHeader(HEADER_NAME_ID, Integer.toString(id));
        String hash = HashUtil.createSHA256(RestClient.generateStringForHash(httpRequest.getMethod(), methodWithParams, body, id, apiKey));
        httpRequest.addHeader(HEADER_NAME_HASH, hash);
    }

    private <T> T executeHttpRequest(HttpRequestBase httpRequest, Class<T> responseType) throws IOException {
        if (this.client == null) {
            throw new IOException("Http client not initialized");
        }
        CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)httpRequest);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            throw new IOException(httpResponse.getStatusLine().toString());
        }
        if (httpResponse.getHeaders(HEADER_SERVER_LABEL_NAME) == null || httpResponse.getHeaders(HEADER_SERVER_LABEL_NAME).length == 0) {
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            throw new IOException("Fiscal server not available");
        }
        String resp = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)DEFAULT_CHARSET.name());
        if (resp != null) {
            Gson gson = new GsonBuilder().setDateFormat(JSON_FORMAT_PATTERN).create();
            try {
                return (T)gson.fromJson(resp, responseType);
            }
            catch (JsonSyntaxException jpe) {
                throw new IOException("Error parse response", jpe);
            }
            catch (Exception e) {
                throw new IOException("Unknown error", e);
            }
        }
        throw new IOException("Empty response");
    }

    private static String generateStringForHash(Object ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(SIGN_HASH_SEPARATOR);
            }
            sb.append(params[i]);
        }
        return sb.toString();
    }
}

