/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.fs.client;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import ru.softlogic.fs.client.errors.CreateClientException;

class CustomHttpClientBuilder
extends HttpClientBuilder {
    private static final int BUFFER_SIZE = 32768;
    private static final int SOCKET_TIMEOUT = 30000;
    private static final int CONNECT_TIMEOUT = 30000;
    private static final String AGENT = "Soft-logic KkmServer Client/2.4.0";
    private static final String ERROR_CREATE_HTTP_CLIENT = "Error on create HttpClient";

    CustomHttpClientBuilder() throws CreateClientException {
        try {
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(CustomHttpClientBuilder.buildSSLContext(), CustomHttpClientBuilder.createVerifier());
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslSocketFactory).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            RequestConfig config = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setExpectContinueEnabled(true).build();
            ConnectionConfig connConfig = ConnectionConfig.custom().setBufferSize(32768).build();
            this.setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            this.setConnectionManager((HttpClientConnectionManager)connectionManager);
            this.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(5, false));
            this.setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier());
            this.setDefaultConnectionConfig(connConfig);
            this.setDefaultRequestConfig(config);
            this.disableContentCompression();
            this.setUserAgent(AGENT);
        }
        catch (KeyManagementException ex) {
            throw new CreateClientException(ERROR_CREATE_HTTP_CLIENT, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CreateClientException(ERROR_CREATE_HTTP_CLIENT, ex);
        }
    }

    private static HostnameVerifier createVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    private static SSLContext buildSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sslContext;
    }
}

