/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ru.softlogic.storage.io.BaseSerializator;
import ru.softlogic.storage.io.SerializatorErrorListener;

public abstract class Serializator
implements Closeable {
    private static SerializatorErrorListener listener = new StdoutErrorListener();

    public static void setErrorListener(SerializatorErrorListener listener) {
        Serializator.listener = listener;
    }

    public abstract void writeObject(Serializable var1);

    public abstract Object readObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static Object readObjectByStream(File f) {
        if (f.isFile() && f.length() > 0L) {
            Object object;
            ObjectInputStream ois = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                ois = new ObjectInputStream(fis);
                object = ois.readObject();
            }
            catch (IOException ex) {
                Serializator.notifyException(ex);
                BaseSerializator.closeQuetly(fis);
                BaseSerializator.closeQuetly(ois);
            }
            catch (ClassNotFoundException ex2) {
                Serializator.notifyException(ex2);
                {
                    catch (Throwable throwable) {
                        BaseSerializator.closeQuetly(fis);
                        BaseSerializator.closeQuetly(ois);
                        throw throwable;
                    }
                }
                BaseSerializator.closeQuetly(fis);
                BaseSerializator.closeQuetly(ois);
            }
            BaseSerializator.closeQuetly(fis);
            BaseSerializator.closeQuetly(ois);
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeObjectByStream(Serializable t, File f) {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(t);
        }
        catch (IOException ex) {
            try {
                Serializator.notifyException(ex);
            }
            catch (Throwable throwable) {
                BaseSerializator.closeQuetly(fos);
                BaseSerializator.closeQuetly(oos);
                throw throwable;
            }
            BaseSerializator.closeQuetly(fos);
            BaseSerializator.closeQuetly(oos);
        }
        BaseSerializator.closeQuetly(fos);
        BaseSerializator.closeQuetly(oos);
    }

    protected static void notifyException(Exception ex) {
        if (listener != null) {
            listener.onError(ex);
        }
    }

    private static class StdoutErrorListener
    implements SerializatorErrorListener {
        private StdoutErrorListener() {
        }

        @Override
        public void onError(Exception ex) {
            ex.printStackTrace();
        }
    }
}

