/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ru.softlogic.storage.io.ObjectIO;
import ru.softlogic.storage.io.Serializator;

public class SequenceDataStore {
    private final ObjectIO<HashMap<Integer, Integer>> objectIO;
    private HashMap<Integer, Integer> data;

    public SequenceDataStore(Serializator serializator) {
        if (serializator == null) {
            throw new NullPointerException("Serializator must be not null");
        }
        this.objectIO = new ObjectIO(serializator);
    }

    public synchronized int current(int sequenceId) {
        this.load();
        return this.data.getOrDefault(sequenceId, 0);
    }

    public synchronized int next(int sequenceId) {
        this.load();
        int res = this.data.getOrDefault(sequenceId, 0) + 1;
        this.data.put(sequenceId, res);
        this.objectIO.write(this.data);
        return res;
    }

    private void load() {
        if (this.data == null) {
            this.data = this.objectIO.read(new HashMap());
            Iterator<Map.Entry<Integer, Integer>> it = this.data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Integer> e = it.next();
                if (e.getValue() != 0) continue;
                it.remove();
            }
        }
    }
}

