/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import ru.softlogic.storage.io.FileHolder;
import ru.softlogic.storage.io.FileSet;
import ru.softlogic.storage.io.PathLockException;
import ru.softlogic.storage.io.Serializator;
import ru.softlogic.storage.io.WrongPathException;

abstract class BaseSerializator
extends Serializator {
    private final FileHolder lockHolder;

    public BaseSerializator(FileSet fileSet) throws WrongPathException, PathLockException {
        BaseSerializator.checkDir(fileSet.getDir());
        BaseSerializator.checkPath(fileSet.getDir(), fileSet.getMainFile());
        BaseSerializator.checkPath(fileSet.getDir(), fileSet.getBackupFile());
        this.lockHolder = new FileHolder(new File(fileSet.getDir(), fileSet.getLockFile()), false);
    }

    protected static final void checkDir(String dir) throws WrongPathException {
        File file = new File(dir);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new WrongPathException("Is directory: " + file.getAbsolutePath());
            }
            if (!(file.canExecute() && file.canRead() && file.canWrite())) {
                throw new WrongPathException("Wrong permission: " + file.getAbsolutePath());
            }
        } else if (!file.mkdirs()) {
            throw new WrongPathException("Can't create dirs: " + file.getAbsolutePath());
        }
    }

    protected static final void checkPath(String dir, String fileName) throws WrongPathException {
        File file = new File(dir, fileName);
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new WrongPathException("Can't write file: " + file.getAbsolutePath());
            }
            if (!file.canRead()) {
                throw new WrongPathException("Can't read file: " + file.getAbsolutePath());
            }
        } else {
            try {
                if (!file.createNewFile()) {
                    throw new WrongPathException("Can't create file: " + file.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                throw new WrongPathException("Can't create file: " + file.getAbsolutePath(), ex);
            }
        }
    }

    @Override
    public final void writeObject(Serializable object) {
        if (this.lockHolder == null) {
            throw new IllegalStateException("Serilizator was closed");
        }
        this.writeObjectImpl(object);
    }

    @Override
    public Object readObject() {
        if (this.lockHolder == null) {
            throw new IllegalStateException("Serilizator was closed");
        }
        return this.readObjectImpl();
    }

    @Override
    public final void close() throws IOException {
        try {
            this.closeImpl();
        }
        finally {
            this.lockHolder.release();
            this.lockHolder.getFile().delete();
        }
    }

    protected static void closeQuetly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract void writeObjectImpl(Serializable var1);

    protected abstract Object readObjectImpl();

    protected abstract void closeImpl() throws IOException;
}

