/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.DefaultComparator;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxData;
import ru.softlogic.storage.cash.BoxInfo;
import ru.softlogic.storage.cash.Collection;
import ru.softlogic.storage.cash.StoreListener;
import ru.softlogic.storage.cash.StoreWrapper;
import ru.softlogic.storage.cash.Transfer;
import ru.softlogic.storage.cash.WrongOperationException;
import ru.softlogic.storage.io.ObjectIO;
import ru.softlogic.storage.io.Serializator;

public class InternalStorage {
    private final Logger log = Logger.getLogger(InternalStorage.class);
    private final Set<StoreListener> listeners = new HashSet<StoreListener>();
    private Map<Short, BoxData> store;
    private ObjectIO<StoreWrapper> objectIO;
    private String token;

    public InternalStorage(Serializator serializator) {
        this(serializator, null);
    }

    public InternalStorage(Serializator serializator, String token) {
        if (serializator == null) {
            throw new NullPointerException("Serializaror is null");
        }
        this.objectIO = new ObjectIO(serializator);
        this.token = token;
    }

    public Set<StoreListener> getListeners() {
        return this.listeners;
    }

    public synchronized Map<Denomination, Integer> getCounts(Box box) {
        TreeMap<Denomination, Integer> res = new TreeMap<Denomination, Integer>(new DefaultComparator());
        res.putAll(this.getBoxData(box.getId()).getCounts());
        return res;
    }

    public synchronized Date getLastRefill(Box box) {
        return this.getBoxData(box.getId()).getLastRefill();
    }

    public synchronized Date getLastEmpty(Box box) {
        return this.getBoxData(box.getId()).getLastEmpty();
    }

    public synchronized Collection clear(Box box) {
        this.log.info((Object)(this.getToken() + "Clean " + box));
        BoxData bd = this.getBoxData(box.getId());
        this.store.put(box.getId(), new BoxData(new HashMap<Denomination, Integer>(), new Date(), bd.getLastRefill()));
        this.updateStorage();
        return new Collection(Collections.unmodifiableMap(bd.getCounts()), bd.getLastEmpty());
    }

    public synchronized void refill(Box box, Map<Denomination, Integer> counts) throws WrongOperationException {
        this.log.info((Object)(this.getToken() + "Refill " + box + ", counts: " + counts));
        this.checkCounts(counts, box.getBoxInfo());
        if (!box.getBoxInfo().isFeatureSupport(4) && counts.size() > 1) {
            throw new WrongOperationException("Box support only one denomination");
        }
        BoxData bd = this.getBoxData(box.getId());
        if (!box.getBoxInfo().isFeatureSupport(32) && !bd.getCounts().isEmpty()) {
            throw new WrongOperationException("Box " + box.getId() + " must be empty!");
        }
        HashMap<Denomination, Integer> res = new HashMap<Denomination, Integer>();
        for (Map.Entry<Denomination, Integer> entry : counts.entrySet()) {
            Integer cnt = bd.getCounts().get(entry.getKey());
            res.put(entry.getKey(), entry.getValue() + (cnt != null ? cnt : 0));
        }
        if (!box.getBoxInfo().isFeatureSupport(4) && res.size() > 1) {
            throw new WrongOperationException("Box support only one denomination");
        }
        this.store.put(box.getId(), new BoxData(res, bd.getLastEmpty(), new Date()));
        this.updateStorage();
    }

    public synchronized void add(Box box, Denomination denomination, int count) {
        this.log.info((Object)(this.getToken() + "Add " + box + ", den: " + denomination + ", counts: " + count));
        this.check(denomination, count, box.getBoxInfo());
        BoxData bd = this.getBoxData(box.getId());
        bd.getCounts().put(denomination, bd.getCounts().getOrDefault(denomination, 0) + count);
        this.store.put(box.getId(), bd);
        this.updateStorage();
    }

    public synchronized void remove(Box box, Denomination denomination, int count) {
        this.remove(box.getId(), denomination, count);
    }

    public synchronized void remove(short boxId, Denomination denomination, int count) {
        this.log.info((Object)(this.getToken() + "Remove " + boxId + ", den: " + denomination + ", counts: " + count));
        this.check(denomination, count);
        BoxData bd = this.getBoxData(boxId);
        int cnt = bd.getCounts().getOrDefault(denomination, 0);
        if (cnt < count) {
            throw new IllegalArgumentException("Not enough denominations in the box. Required " + count + ", have " + cnt);
        }
        if (cnt == count) {
            bd.getCounts().remove(denomination);
        } else {
            bd.getCounts().put(denomination, cnt - count);
        }
        this.store.put(boxId, bd);
        this.updateStorage();
    }

    public synchronized void remove(short boxId, Map<Denomination, Integer> counts) {
        this.log.info((Object)(this.getToken() + "Remove " + boxId + ", counts: " + counts));
        BoxData bd = this.getBoxData(boxId);
        for (Map.Entry<Denomination, Integer> entry : counts.entrySet()) {
            int cnt = bd.getCounts().getOrDefault(entry.getKey(), 0);
            if (cnt < entry.getValue()) {
                throw new IllegalArgumentException("Not enough " + entry.getKey() + " in the box. Required " + entry.getValue() + ", have " + cnt);
            }
            if (cnt == entry.getValue()) {
                bd.getCounts().remove(entry.getKey());
                continue;
            }
            bd.getCounts().put(entry.getKey(), cnt - entry.getValue());
        }
        this.store.put(boxId, bd);
        this.updateStorage();
    }

    public synchronized void fullTransfer(short fromBoxId, short toBoxId) {
        this.log.info((Object)(this.getToken() + "Full transfer " + fromBoxId + "->" + toBoxId));
        DenominationSet ds = new DenominationSet(this.getBoxData(fromBoxId).getCounts());
        if (!ds.isEmpty()) {
            this._transfer(fromBoxId, toBoxId, ds);
            LinkedList<Transfer> transfers = new LinkedList<Transfer>();
            transfers.add(new Transfer(fromBoxId, toBoxId, ds));
            for (StoreListener sl : this.listeners) {
                sl.onTransfers(transfers);
            }
            this.updateStorage();
        }
    }

    public synchronized int getCount(short boxId, Denomination den) {
        BoxData bd = this.getBoxData(boxId);
        Integer cnt = bd.getCounts().get(den);
        return cnt != null ? cnt : 0;
    }

    public synchronized void transfer(List<Transfer> transfers) {
        if (transfers.isEmpty()) {
            return;
        }
        for (Transfer t : transfers) {
            this._transfer(t.getBoxFrom(), t.getBoxTo(), t.getCounts());
        }
        for (StoreListener sl : this.listeners) {
            sl.onTransfers(transfers);
        }
        this.updateStorage();
    }

    private void _transfer(short fromBoxId, short toBoxId, DenominationSet ds) {
        this.log.info((Object)(this.getToken() + "Transfer  " + fromBoxId + "->" + toBoxId + ", ds=" + ds));
        BoxData fromBox = this.getBoxData(fromBoxId);
        BoxData toBox = this.getBoxData(toBoxId);
        for (Map.Entry<Denomination, Integer> entry : ds.getCounts().entrySet()) {
            int countFrom = fromBox.getCounts().getOrDefault(entry.getKey(), 0);
            int countTo = toBox.getCounts().getOrDefault(entry.getKey(), 0);
            if (countFrom < entry.getValue()) {
                throw new IllegalArgumentException("Total count less zero. Box " + fromBoxId + ", " + entry.getKey() + ",exist=" + countFrom + ", requested=" + entry.getValue());
            }
            if (countFrom == entry.getValue()) {
                fromBox.getCounts().remove(entry.getKey());
            } else {
                fromBox.getCounts().put(entry.getKey(), countFrom - entry.getValue());
            }
            toBox.getCounts().put(entry.getKey(), countTo + entry.getValue());
        }
        this.store.put(fromBoxId, fromBox);
        this.store.put(toBoxId, toBox);
    }

    private BoxData getBoxData(short boxId) {
        this.checkInit();
        BoxData bd = this.store.get(boxId);
        return bd != null ? bd : new BoxData();
    }

    private void checkInit() {
        if (this.store == null) {
            this.store = this.objectIO.read(new StoreWrapper(new HashMap<Short, BoxData>())).getStore();
            Iterator<Map.Entry<Short, BoxData>> it = this.store.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Short, BoxData> e = it.next();
                BoxData bd = e.getValue();
                if (bd.getLastEmpty() != null || bd.getLastRefill() != null || !bd.getCounts().isEmpty()) continue;
                it.remove();
            }
            this.log.info((Object)(this.getToken() + "Loaded: " + this.store));
        }
    }

    private void checkCounts(Map<Denomination, Integer> counts, BoxInfo boxInfo) {
        if (counts == null) {
            throw new NullPointerException("Counts");
        }
        for (Map.Entry<Denomination, Integer> entry : counts.entrySet()) {
            this.check(entry.getKey(), entry.getValue(), boxInfo);
        }
    }

    private void check(Denomination den, Integer count, BoxInfo boxInfo) {
        int type;
        this.check(den, count);
        int n = type = boxInfo.isFeatureSupport(64) ? 1 : 0;
        if (den.getType() != type) {
            throw new IllegalArgumentException("Wrong denomination type");
        }
    }

    private void check(Denomination den, Integer count) {
        if (den == null) {
            throw new IllegalArgumentException("Denomination is null");
        }
        if (count == null) {
            throw new IllegalArgumentException("Count is null");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive");
        }
    }

    private void updateStorage() {
        this.log.info((Object)(this.getToken() + "Update storage: " + this.store));
        this.objectIO.write(new StoreWrapper(this.store));
    }

    private String getToken() {
        return (this.token != null ? this.token : this.toString()) + ": ";
    }
}

