/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import java.util.Arrays;
import java.util.Iterator;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.cash.StoreListener;

public class BaseStore
implements Store {
    private final String title;
    private final Box[] boxes;
    private final InternalStorage storage;

    public BaseStore(String title, Box[] boxes, InternalStorage storage) {
        if (title == null) {
            throw new NullPointerException("Title is null");
        }
        if (boxes == null) {
            throw new NullPointerException("Boxes is null");
        }
        if (boxes.length == 0) {
            throw new IllegalArgumentException("Boxes is empty");
        }
        if (storage == null) {
            throw new NullPointerException("StoreData is null");
        }
        this.title = title;
        this.boxes = boxes;
        this.storage = storage;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes;
    }

    @Override
    public void addListener(StoreListener listener) {
        this.check(listener);
        this.storage.getListeners().add(listener);
    }

    @Override
    public void removeListener(StoreListener listener) {
        this.check(listener);
        this.storage.getListeners().remove(listener);
    }

    private void check(StoreListener listener) {
        if (listener == null) {
            throw new NullPointerException("StoreListener is null");
        }
    }

    @Override
    public Iterator<Box> iterator() {
        return Arrays.asList(this.boxes).iterator();
    }
}

