/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxInfo;
import ru.softlogic.storage.cash.Collection;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.PhysicalBox;
import ru.softlogic.storage.cash.Producer;
import ru.softlogic.storage.cash.StoreUtils;
import ru.softlogic.storage.cash.VoidProducer;
import ru.softlogic.storage.cash.WrongOperationException;

public class BaseBox
implements Box {
    private final short boxId;
    private final BoxInfo boxInfo;
    private final InternalStorage storage;
    private final PhysicalBox physicalBox;
    private final Producer producer;

    public BaseBox(short boxId, BoxInfo boxInfo, InternalStorage storage) {
        this(boxId, boxInfo, storage, null);
    }

    public BaseBox(short boxId, BoxInfo boxInfo, InternalStorage storage, PhysicalBox physicalBox) {
        this(boxId, boxInfo, storage, physicalBox, new VoidProducer());
    }

    public BaseBox(short boxId, BoxInfo boxInfo, InternalStorage storage, PhysicalBox physicalBox, Producer producer) {
        if (boxInfo == null) {
            throw new NullPointerException("BoxInfo is null");
        }
        if (storage == null) {
            throw new NullPointerException("StoreCore is null");
        }
        if (producer == null) {
            throw new NullPointerException("Producer is null");
        }
        StoreUtils.checkBoxId(boxId);
        this.boxId = boxId;
        this.boxInfo = boxInfo;
        this.storage = storage;
        this.physicalBox = physicalBox;
        this.producer = producer;
    }

    @Override
    public short getId() {
        return this.boxId;
    }

    @Override
    public BoxInfo getBoxInfo() {
        return this.boxInfo;
    }

    @Override
    public Map<Denomination, Integer> getCounts() {
        return this.storage.getCounts(this);
    }

    @Override
    public void refill(Denomination den, int count) throws WrongOperationException {
        HashMap<Denomination, Integer> counts = new HashMap<Denomination, Integer>();
        counts.put(den, count);
        this.refill(counts);
    }

    @Override
    public void refill(Map<Denomination, Integer> counts) throws WrongOperationException {
        if (!this.getBoxInfo().isFeatureSupport(2)) {
            throw new WrongOperationException("Operation is not supported");
        }
        this.storage.refill(this, counts);
    }

    @Override
    public Date getLastRefill() {
        return this.storage.getLastRefill(this);
    }

    @Override
    public Collection empty() throws WrongOperationException {
        if (!this.getBoxInfo().isFeatureSupport(1)) {
            throw new WrongOperationException("Operation is not supported");
        }
        return this.storage.clear(this);
    }

    @Override
    public Date getLastEmpty() {
        return this.storage.getLastEmpty(this);
    }

    public String toString() {
        return "BaseBox{boxId=" + this.boxId + ", boxInfo=" + this.boxInfo + '}';
    }

    @Override
    public PhysicalBox getPhysicalBox() {
        return this.physicalBox;
    }

    @Override
    public boolean isEmpty() {
        Map<Denomination, Integer> content = this.storage.getCounts(this);
        if (content.isEmpty()) {
            return true;
        }
        for (Integer cnt : content.values()) {
            if (cnt <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Denomination> getSupportedDenominations() {
        return this.producer.getDenominations();
    }
}

