/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout.alg;

import ru.softlogic.payout.alg.BasePayoutCalculator;
import ru.softlogic.payout.alg.DynamicBag;
import ru.softlogic.payout.alg.GeneticBag;
import ru.softlogic.payout.alg.GreedyAlgorithmCalculator;
import ru.softlogic.payout.alg.SimplexMethod;

public final class PayoutCalculatorFactory {
    public static final String ALG_DEFAULT = "default";
    public static final String ALG_GREEDY = "greedy";
    public static final String ALG_GENETIC = "genetic";
    public static final String ALG_SIMPLEX = "simplex";
    public static final String ALG_DYNAMIC = "dynamic";

    private PayoutCalculatorFactory() {
    }

    public static BasePayoutCalculator create(String algorithm) {
        if (ALG_GREEDY.equals(algorithm)) {
            return new GreedyAlgorithmCalculator();
        }
        if (ALG_DYNAMIC.equals(algorithm)) {
            return new DynamicBag();
        }
        if (ALG_GENETIC.equals(algorithm)) {
            return new GeneticBag();
        }
        if (ALG_SIMPLEX.equals(algorithm)) {
            return new SimplexMethod();
        }
        return new GreedyAlgorithmCalculator();
    }
}

