/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout;

import java.util.Comparator;
import java.util.Map;
import ru.softlogic.hdw.dev.cashdisp.CashDispenser;

class DevicePriorityComparator
implements Comparator<CashDispenser> {
    private final Map<Short, Integer> priorityTable;

    public DevicePriorityComparator(Map<Short, Integer> priorityTable) {
        this.priorityTable = priorityTable;
    }

    @Override
    public int compare(CashDispenser dev1, CashDispenser dev2) {
        if (dev1.getLastInfo() == null) {
            return dev2.getLastInfo() == null ? 0 : 1;
        }
        if (dev2.getLastInfo() == null) {
            return -1;
        }
        Integer priorityDev1 = this.priorityTable.get(dev1.getLastInfo().getDeviceClass());
        Integer priorityDev2 = this.priorityTable.get(dev2.getLastInfo().getDeviceClass());
        if (priorityDev1 == null) {
            return priorityDev2 == null ? 0 : 1;
        }
        return priorityDev2 == null ? -1 : priorityDev1.compareTo(priorityDev2);
    }
}

