/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.handling;

public class DeviceState {
    public static final int STATE_OK = 0;
    public static final int STATE_CREATING_ERROR = -1;
    public static final int STATE_IO_ERROR = -2;
    public static final int STATE_EMPTY = -3;
    public static final int STATE_BUSY = -4;
    public static final int STATE_JAM = -5;
    public static final int STATE_UNKNOWN = -6;
    public static final int STATE_COMMON_ERROR = -7;
    public static final int STATE_SERVICING = -8;
    public static final int FLAG_OK = 0;
    public static final int FLAG_UNSTABLE_CONNECTION = Integer.MIN_VALUE;
    private final short deviceClass;
    private final int state;
    private int flags;

    public DeviceState(short deviceClass, int state) {
        this.deviceClass = deviceClass;
        this.state = state;
    }

    public DeviceState(short deviceClass, int state, int flags) {
        this.deviceClass = deviceClass;
        this.state = state;
        this.flags = flags;
    }

    public int getState() {
        return this.state;
    }

    public int getFlags() {
        return this.flags;
    }

    public short getDeviceClass() {
        return this.deviceClass;
    }

    public boolean isOk() {
        return this.state == 0;
    }

    public String toString() {
        return "DeviceState{deviceClass=" + this.deviceClass + ", state=" + this.state + ", flags=" + this.flags + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.deviceClass;
        hash = 29 * hash + this.state;
        hash = 29 * hash + this.flags;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceState)) {
            return false;
        }
        DeviceState other = (DeviceState)obj;
        if (this.deviceClass != other.deviceClass) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return this.flags == other.flags;
    }
}

