/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.sensors;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.softlogic.config.BaseSection;
import ru.softlogic.config.ParceException;
import ru.softlogic.hdw.dev.sensors.SensorOptions;
import ru.softlogic.hdw.dev.sensors.SnrConfiguration;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.usb.UsbPort;

public class SnrSection
extends BaseSection {
    private SnrConfiguration conf;

    public SnrSection() {
    }

    public SnrSection(SnrConfiguration conf) {
        if (conf == null) {
            throw new NullPointerException("SensorConfiguration is null");
        }
        this.conf = conf;
    }

    @Override
    public String getGroup() {
        return "hardware";
    }

    @Override
    public String getKey() {
        return "sensor";
    }

    @Override
    public void parce(Element element) throws ParceException {
        boolean enable = this.getEnable(element);
        String driver = this.getDriver(element);
        Port port = this.getPort(element);
        this.conf = new SnrConfiguration(enable, driver, port, new SensorOptions());
    }

    protected String getDriver(Element element) {
        return element.getAttribute("driver");
    }

    protected boolean getEnable(Element element) {
        return this.readBoolean(element.getAttribute("active"), true);
    }

    @Override
    public Node generate(Document doc) {
        if (this.conf != null) {
            Element root = doc.createElement(this.getKey());
            root.setAttribute("active", Boolean.toString(this.conf.isEnable()));
            root.setAttribute("driver", this.conf.getDriver());
            if (this.conf.getPort() != null) {
                root.setAttribute("port", this.conf.getPort().asStr());
            }
            return root;
        }
        return null;
    }

    public SnrConfiguration getConfiguration() {
        return this.conf;
    }

    protected Port getPort(Element element) throws ParceException {
        String port = element.getAttribute("port");
        if (port.isEmpty()) {
            return null;
        }
        if (port.toLowerCase().matches("[a-z0-9/]+:\\d+,\\d,\\d,(none|odd|even|mark|space)")) {
            String[] paths = port.split(":");
            String[] pr = paths[1].split(",");
            if (PortScanner.suggestType((String)paths[0]) != PortType.SerialPort) {
                throw new ParceException("Wrong port type, needs serial " + paths[0]);
            }
            return new SerialPort(paths[0], new SerialParams(Integer.parseInt(pr[0]), DataBits.value((String)pr[1]), StopBits.value((String)pr[2]), Parity.valueOf((String)pr[3])));
        }
        PortType pt = PortScanner.suggestType((String)port);
        if (pt == PortType.ParallelPort) {
            return new ParallelPort(port);
        }
        return new UsbPort(port);
    }
}

