/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.sensors;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ru.softlogic.hdw.dev.sensors.SensorEvent;
import ru.softlogic.hdw.dev.sensors.SensorsListener;

public class Sensor {
    public static final int SENSOR_DOOR = 1;
    public static final int SENSOR_SHOCK = 2;
    public static final int SENSOR_TEMPERATURE = 3;
    public static final int STATE_ONE = 1;
    public static final int STATE_MULTI = 2;
    private final short deviceClass;
    private final int sensorType;
    private final int id;
    private final int stateType;
    private int lastValue;
    private final Set<SensorsListener> listeners;

    public Sensor(short deviceClass, int sensorType, int id) {
        this.deviceClass = deviceClass;
        this.sensorType = sensorType;
        this.id = id;
        this.stateType = 2;
        this.listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public Sensor(short deviceClass, int sensorType, int id, int statesType) {
        this.deviceClass = deviceClass;
        this.sensorType = sensorType;
        this.id = id;
        this.stateType = statesType;
        this.listeners = new HashSet<SensorsListener>();
    }

    public short getDeviceClass() {
        return this.deviceClass;
    }

    public int getType() {
        return this.sensorType;
    }

    public int getId() {
        return this.id;
    }

    public void addListener(SensorsListener listener) {
        if (listener == null) {
            throw new NullPointerException("Sensor listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(SensorsListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyListeners(int value) {
        if (this.listeners != null && (this.lastValue != value || this.stateType == 1)) {
            this.lastValue = value;
            for (SensorsListener sl : this.listeners) {
                sl.onChange(new SensorEvent(this, value));
            }
        }
    }

    public String toString() {
        return "Sensor{type=" + this.sensorType + ", id=" + this.id + ", lastValue=" + this.lastValue + ", listeners=" + this.listeners + '}';
    }
}

