/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.tpl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class DefaultTemplateExctractor {
    private DefaultTemplateExctractor() {
    }

    public static InputStream getInternalTemplateStream(short deviceClass, String name, Locale locale, String defResource) throws IOException {
        String path = DefaultTemplateExctractor.getPathByType(deviceClass) + name;
        InputStream is = DefaultTemplateExctractor.getStreamFromJar(path, locale, defResource);
        if (is == null) {
            throw new IOException("Internal template is not found by path: " + path + ", default resource: " + defResource);
        }
        return is;
    }

    protected static String getPathByType(short deviceClass) {
        switch (deviceClass) {
            case 1: {
                return "ipp/";
            }
            case 2: {
                return "kkm/";
            }
        }
        return "pos/";
    }

    protected static InputStream getStreamFromJar(String path, Locale locale, String defResource) {
        if (path == null || locale == null) {
            return null;
        }
        String res = path.replace("{0}", "_" + locale.getLanguage() + "_" + locale.getCountry());
        InputStream is = DefaultTemplateExctractor.class.getResourceAsStream(res);
        if (is == null && (is = DefaultTemplateExctractor.class.getResourceAsStream(res = path.replace("{0}", "_" + locale.getLanguage()))) == null) {
            res = path.replace("{0}", defResource);
            is = DefaultTemplateExctractor.class.getResourceAsStream(res);
        }
        return is;
    }
}

