/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.spooler;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.printer.PrintException;
import ru.softlogic.hdw.dev.printer.PrintSpooler;
import ru.softlogic.hdw.dev.printer.Printer;
import ru.softlogic.hdw.dev.printer.spooler.PrintSpoolerDriver;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;

public class DefaultPrintSpoolerDriver
extends BaseDevice
implements PrintSpooler,
PrintSpoolerDriver,
Runnable {
    private static final String BASE_VERSION = "c2.0.1";
    private final Printer printer;
    private final Logger log;
    private final List<Thread> threads;
    private final BlockingQueue<PrinterJob> queue;

    public DefaultPrintSpoolerDriver(Printer printer, DeviceId deviceId, Logger log) {
        super(deviceId, BASE_VERSION, log);
        this.printer = printer;
        this.log = log;
        this.queue = new LinkedBlockingQueue<PrinterJob>();
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(pos)"));
    }

    @Override
    public void print(PrinterJob job) {
        if (job == null) {
            throw new NullPointerException("PrinterJob is null");
        }
        this.queue.add(job);
        this.notifySleep();
    }

    @Override
    public PrintSpooler getPrintSpooler() {
        return this;
    }

    @Override
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public short getPrinterClass() {
        return this.printer.getPrinterClass();
    }

    @Override
    public void run() {
        this.log.info((Object)"Thread start");
        boolean open = false;
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    PrinterJob el;
                    if (!open) {
                        this.printer.open();
                        this.updateDeviceInfo(this.printer.init());
                        this.sleep(3000);
                        this.updateState(this.printer.requestState());
                        open = true;
                    }
                    if ((el = this.queue.poll(5L, TimeUnit.SECONDS)) != null) {
                        this.log.info((Object)("Get job: " + el));
                        el.print(this.printer);
                    } else {
                        this.updateState(this.printer.requestState());
                    }
                    this.onConnSuccess();
                }
                catch (PrintException ex) {
                    this.log.info((Object)"Error", (Throwable)ex);
                    this.notifyProblemOnce(ex.getMessage());
                    this.onConnSuccess();
                    this.clearOld();
                }
                catch (IOException ex) {
                    this.onConnErrorWithSleep(ex);
                    open = false;
                    this.printer.close();
                    this.clearOld();
                }
                catch (InterruptedException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    this.log.error((Object)"Unknown error", ex);
                    this.notifyProblem(ex.getMessage());
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.log.info((Object)"Interrupted");
        }
        this.log.info((Object)"Close device");
        this.printer.close();
        this.log.info((Object)"Thread stop");
    }

    private void clearOld() {
        while (this.queue.size() > 3) {
            this.log.error((Object)("Clear old " + this.queue.poll()));
        }
    }
}

