/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.KkmModule;
import ru.softlogic.hdw.dev.printer.Printer;
import ru.softlogic.hdw.dev.printer.PrnUtils;
import ru.softlogic.hdw.dev.printer.pos.ImageApi;
import ru.softlogic.hdw.dev.printer.pos.InfoApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterUtils;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.SecurityApi;
import ru.softlogic.hdw.dev.printer.pos.StatisticApi;
import ru.softlogic.hdw.dev.printer.pos.pblock.PrintBlock;
import ru.softlogic.hdw.dev.printer.pos.pblock.TemplateParser;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.utils.BU;

public class PosPrinter
implements Printer {
    private static final String DRIVER_VERSION = "2.0.1";
    private final String type;
    private final PosPrinterApi api;
    private final PosPrtOptions options;
    private Logger log;

    public PosPrinter(String type, PosPrinterApi api, PosPrtOptions options, Logger log) {
        if (type == null) {
            throw new NullPointerException("Type is null");
        }
        if (api == null) {
            throw new NullPointerException("PosPrinterApi is null");
        }
        if (options == null) {
            throw new NullPointerException("PosPrtOptions is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.type = type;
        this.api = api;
        this.options = options;
        this.log = log;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public DeviceInfo init() throws IOException {
        this.log.info((Object)"-----------------------------------------------------------");
        DeviceInfo di = new DeviceInfo(0, this.type);
        di.setPort(this.api.getPortAsStr());
        di.setDriver(DRIVER_VERSION);
        InfoApi ia = this.api.getInfoApi();
        if (ia != null) {
            this.log.info((Object)"Printer provides info api, request info");
            int id = ia.getModelId();
            this.log.info((Object)("    Device Id: " + id + " " + String.format("(0x%02x)", id)));
            String vendor = ia.getVendor();
            this.log.info((Object)("    Vendor: " + vendor));
            di.setVendor(vendor);
            String model = ia.getModel();
            this.log.info((Object)("    Model: " + model));
            di.setModel(model + ", " + BU.toHex((int)id));
            String firmware = ia.getFirmware();
            this.log.info((Object)("    Firmware: " + firmware));
            di.setFirmware(firmware);
        }
        try {
            this.log.info((Object)"Try to reset printer");
            this.api.reset();
            this.log.info((Object)"Success!");
        }
        catch (IOException ex) {
            this.log.info((Object)("Error: " + ex.getMessage()));
        }
        this.log.info((Object)("Print width : " + this.options.getWidth()));
        this.log.info((Object)("Left margin : " + this.options.getLeftMargin()));
        this.log.info((Object)("Paper scroll : " + this.options.getScroll()));
        this.log.info((Object)("Eject : " + this.options.getEject()));
        this.log.info((Object)("Encoding : " + this.options.getEncode()));
        di.setInfo("width:" + this.options.getWidth() + ", margin:" + this.options.getLeftMargin() + ", scroll:" + this.options.getScroll() + ", eject:" + this.options.getEject() + ", enc:" + this.options.getEncode());
        ImageApi ima = this.api.getImageApi();
        if (ima != null) {
            this.log.info((Object)"Printer support image api, load image");
            File f = PrnUtils.getLogoPath("logo.png");
            if (f.canRead()) {
                try {
                    ima.loadImage(f);
                    this.log.info((Object)"Success!");
                }
                catch (Exception ex) {
                    this.log.error((Object)("Error on loading: " + ex.getMessage()));
                }
            } else {
                this.log.info((Object)("Logo file is not found, skip load. Search path: " + f.getAbsolutePath()));
            }
        }
        return di;
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public KkmModule getKkmModule() {
        return null;
    }

    @Override
    public void print(String text) throws IOException {
        if (text == null) {
            throw new NullPointerException("Text is null");
        }
        String pt = text;
        for (Map.Entry<Character, Character> e : PosPrinterUtils.getReplaceMap().entrySet()) {
            pt = pt.replace(e.getKey().charValue(), e.getValue().charValue());
        }
        StatisticApi statisticApi = this.api.getStatisticApi();
        this.statLogging(statisticApi);
        String[] docs = pt.replace("<!br><br>", "").replace("<!br>\r\n", "").replace("<!br>\n", "").replace("\r\n", "<br>").replace("\n", "<br>").split("<cut/>");
        if (docs.length > 0) {
            SecurityApi securityApi = this.api.getSecurityApi();
            if (securityApi != null) {
                this.log.info((Object)"Printer supports security api, process it");
                securityApi.process();
            }
            boolean first = true;
            try {
                for (String str : docs) {
                    if (!str.trim().isEmpty()) {
                        if (!first) {
                            Thread.sleep(5000L);
                        }
                        this.print(str, 0);
                    }
                    if (!first) continue;
                    first = false;
                }
                Thread.sleep(1000L);
                this.statLogging(statisticApi);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void statLogging(StatisticApi statisticApi) throws IOException {
        if (statisticApi != null) {
            this.log.info((Object)"Printer statistics:");
            this.log.info((Object)("    Paper length : " + statisticApi.getPrintedLength()));
            this.log.info((Object)("    Cuts number  : " + statisticApi.getCutsNumber()));
            this.log.info((Object)("    Retracting   : " + statisticApi.getRetrackingNumber()));
            this.log.info((Object)("    Power up     : " + statisticApi.getPowerUpNumber()));
        }
    }

    protected void print(String text, int cutType) throws IOException, InterruptedException {
        this.log.info((Object)("Init printer: " + this.options));
        this.api.init();
        this.log.info((Object)("Process text (len=" + text.length() + "): " + text));
        List<PrintBlock> pbs = TemplateParser.parce(text, this.log);
        this.log.info((Object)("Blocks count: " + pbs.size()));
        for (PrintBlock pb : pbs) {
            this.log.info((Object)("Print block: " + pb));
            pb.print(this.api);
        }
        if (this.options.getScroll() > 0) {
            this.log.info((Object)("Make scroll: " + this.options.getScroll()));
            this.api.scroll(this.options.getScroll());
        }
        if (text.length() > 1000) {
            int sleep = (int)((double)text.length() * 0.5);
            this.log.info((Object)("Sleep: " + sleep + " ms"));
            Thread.sleep(sleep);
        }
        this.log.info((Object)"Cut");
        this.api.cut(cutType);
        if (this.options.getEject() > 0) {
            this.log.info((Object)("Eject document " + this.options.getEject()));
            this.api.eject(this.options.getEject());
        }
        this.log.info((Object)"Print done");
    }

    @Override
    public DeviceState requestState() throws IOException {
        DeviceState ds = this.api.getStatus();
        if (!this.options.isUsePneSensor()) {
            ds = new DeviceState(ds.getDeviceClass(), ds.getState(), ds.getFlags() & 0xFFFFFFFE);
        }
        return ds;
    }

    @Override
    public short getPrinterClass() {
        return 0;
    }
}

