/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.kkm;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CodeException;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.printer.KkmModule;
import ru.softlogic.hdw.dev.printer.PrintException;
import ru.softlogic.hdw.dev.printer.Printer;
import ru.softlogic.hdw.dev.printer.PrnUtils;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrinterState;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterState;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.serial.SerialPort;

public abstract class KkmPrinter
implements Printer,
KkmModule {
    private SerialPort port;
    private KkmPrtOptions options;
    private DeviceId deviceId;
    private Logger log;

    public KkmPrinter(SerialPort port, KkmPrtOptions options, DeviceId deviceId, Logger log) {
        if (port == null) {
            throw new NullPointerException("SerialPort is null");
        }
        if (options == null) {
            throw new NullPointerException("KkmPrtOptions is null");
        }
        if (deviceId == null) {
            throw new NullPointerException("DeviceId is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.port = port;
        this.options = options;
        this.deviceId = deviceId;
        this.log = log;
    }

    @Override
    public short getPrinterClass() {
        return this.options.isPrinterMode() ? (short)0 : 2;
    }

    @Override
    public KkmModule getKkmModule() {
        return this.options.isPrinterMode() ? null : this;
    }

    @Override
    public final DeviceState requestState() throws PrintException, IOException {
        return this.options.isPrinterMode() ? this.requestPrnState() : this.requestKkmState();
    }

    protected DeviceInfo createDeviceInfo() {
        DeviceInfo di = new DeviceInfo(this.getPrinterClass(), this.deviceId.getType());
        di.setPort(this.port.asStr());
        return di;
    }

    @Override
    public final DeviceInfo init() throws IOException {
        try {
            this.log.info((Object)("Work mode: " + (this.options.isPrinterMode() ? "PRINTER" : "KKM")));
            return this._init();
        }
        catch (CodeException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            throw new IOException(ex);
        }
    }

    @Override
    public final void print(String text) throws PrintException, IOException {
        this.log.info((Object)("Print text: " + text));
        if (text == null || text.isEmpty()) {
            return;
        }
        this._print(this.removeTags(text));
    }

    protected String removeTags(String str) {
        String s = str;
        for (String tag : PrnUtils.getSupportedTags()) {
            s = s.replace(tag, "");
        }
        return s;
    }

    protected abstract void _print(String var1) throws PrintException, IOException;

    protected abstract PosPrinterState requestPrnState() throws PrintException, IOException;

    protected abstract KkmPrinterState requestKkmState() throws PrintException, IOException;

    protected abstract DeviceInfo _init() throws IOException, CodeException;

    protected boolean isPrintZreportWhileBufferIsFull() {
        return false;
    }

    protected boolean isPrintZreportWhileBufferIsNotSupported() {
        return false;
    }
}

