/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.modem;

import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.modem.ModOptions;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class ModemFactory
extends BaseFactory {
    private ModemFactory() {
    }

    public static Modem createModem(String type, SerialPort port, ModOptions options, Logger log) throws CreatingException {
        ModemFactory.check(type, (Port)port, log);
        if (options == null) {
            throw new CreatingException("ModOptions is not set");
        }
        String pkg = "ru.softlogic.hardware.mod." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            Modem cr = (Modem)cl.getConstructor(String.class, SerialPort.class, ModOptions.class, Logger.class).newInstance(type, port, options, log);
            return cr;
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }
}

