/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.SerialDeviceSection;
import ru.softlogic.hdw.dev.epp.EppConfiguration;
import ru.softlogic.hdw.dev.epp.EppOptions;
import ru.softlogic.io.serial.SerialPort;

public class EppSection
extends SerialDeviceSection {
    public static final String COMPLATE_LEN = "complete-length";
    private EppConfiguration eppConf;

    public EppSection() {
    }

    public EppSection(EppConfiguration eppConf) {
        this.eppConf = eppConf;
    }

    public EppConfiguration getConfiguration() {
        return this.eppConf;
    }

    @Override
    protected void generateOptions(Document doc, Element el) {
        Element opt = doc.createElement("option");
        opt.setAttribute("key", COMPLATE_LEN);
        opt.setAttribute("value", Integer.toString(this.eppConf.getEppOptions().getCompleteLength()));
        el.appendChild(opt);
    }

    @Override
    public String getKey() {
        return "pinpad";
    }

    @Override
    public void parce(Element element) throws ParceException {
        boolean enable = this.getEnable(element);
        String type = this.getDriver(element);
        SerialPort port = this.getSerialPort(element);
        String name = this.getLogicalName(element);
        Map<String, String> opt = this.readOptions(element);
        this.eppConf = new EppConfiguration(enable, type, port, new EppOptions(this.readInt(opt, COMPLATE_LEN, 0)), name);
    }

    @Override
    public Node generate(Document dcmnt) {
        return this.generate(dcmnt, this.eppConf);
    }
}

