/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp;

import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.epp.EppDescriptor;
import ru.softlogic.hdw.dev.epp.EppDriver;
import ru.softlogic.hdw.dev.epp.EppOptions;
import ru.softlogic.hdw.dev.epp.UIDStore;
import ru.softlogic.hdw.dev.epp.init.ChangeKeyRunnable;
import ru.softlogic.hdw.dev.epp.init.Initializator;
import ru.softlogic.hdw.dev.epp.init.InstallRunnable;
import ru.softlogic.hdw.dev.epp.init.ManualKeyInApi;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public final class EppFactory
extends BaseFactory {
    private static final String EPP_PATH = "ru.softlogic.hardware.epp.";

    private EppFactory() {
    }

    public static ChangeKeyRunnable createChangeKeyRunnable(String type, SerialPort port, Logger log) throws CreatingException {
        EppFactory.check(type, (Port)port, log);
        String pkg = EPP_PATH + type.toLowerCase() + ".init.ChangeKeyRunnable";
        try {
            Class<?> cl = Class.forName(pkg);
            ChangeKeyRunnable ckr = (ChangeKeyRunnable)cl.getConstructor(SerialPort.class, Logger.class).newInstance(port, log);
            return ckr;
        }
        catch (Exception ex) {
            throw new CreatingException("Can't create epp change key runnable, type=" + type, ex);
        }
    }

    public static InstallRunnable createInstallRunnable(String type, SerialPort port, Logger log) throws CreatingException {
        EppFactory.check(type, (Port)port, log);
        String pkg = EPP_PATH + type.toLowerCase() + ".init.InstallRunnable";
        try {
            Class<?> cl = Class.forName(pkg);
            InstallRunnable ckr = (InstallRunnable)cl.getConstructor(SerialPort.class, Logger.class).newInstance(port, log);
            return ckr;
        }
        catch (Exception ex) {
            throw new CreatingException("Can't create epp change key runnable, type=" + type, ex);
        }
    }

    public static EppDescriptor createDescriptor(String type) throws CreatingException {
        String path = "/ru/softlogic/hardware/epp/" + type.toLowerCase() + "/descriptor.properties";
        Properties prop = EppFactory.getProperties(path);
        int feat = EppFactory.getFeatures(prop);
        String reinstallPwd = EppFactory.getString(prop, "reinstall-key-value");
        int minWdTimeout = EppFactory.getIntParam(prop, "min-wd-timeout");
        int maxWdTimeout = EppFactory.getIntParam(prop, "max-wd-timeout");
        int reinstallPwdLen = EppFactory.getIntParam(prop, "reinstall-key-len");
        return new EppDescriptor(feat, minWdTimeout, maxWdTimeout, reinstallPwd, reinstallPwdLen);
    }

    public static EppDriver createDriver(String type, SerialPort port, UIDStore store, EppOptions eppOptions, Logger log) throws CreatingException {
        EppFactory.check(type, (Port)port, log);
        if (store == null) {
            throw new CreatingException("UIDStore is not set");
        }
        String pkg = EPP_PATH + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            EppDriver epp = (EppDriver)cl.getConstructor(SerialPort.class, UIDStore.class, EppOptions.class, Logger.class).newInstance(port, store, eppOptions, log);
            return epp;
        }
        catch (Exception ex) {
            throw new CreatingException("Can't create epp driver, type=" + type, ex);
        }
    }

    public static Initializator createInitializator(String type, SerialPort port, UIDStore store, Locale locale, Logger log) throws CreatingException {
        EppFactory.checkType(type);
        String pkg = EPP_PATH + type.toLowerCase() + ".init.Initializator";
        try {
            Class<?> cl = Class.forName(pkg);
            return (Initializator)cl.getConstructor(SerialPort.class, UIDStore.class, Locale.class, Logger.class).newInstance(port, store, locale, log);
        }
        catch (Exception ex) {
            throw new CreatingException("Cant' create epp initializator", ex);
        }
    }

    public static ManualKeyInApi createManualKeyInApi(String type, SerialPort port, UIDStore store, Locale locale, Logger log) throws CreatingException {
        Initializator createInitializator = EppFactory.createInitializator(type, port, store, locale, log);
        return createInitializator.getManualKeyInApi();
    }

    public static EppDriver createXfsDriver(String logicalName, EppOptions options, Logger log) throws CreatingException {
        try {
            return (EppDriver)Class.forName("ru.softlogic.hardware.epp.xfs.driver.Driver").getConstructor(String.class, EppOptions.class, Logger.class).newInstance(logicalName, options, log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }

    public static Initializator createXfsInitializator(String logicalName, Locale locale, Logger log) throws CreatingException {
        if (logicalName == null) {
            return null;
        }
        String pkg = "ru.softlogic.hardware.epp.xfs.init.Initializator";
        try {
            return (Initializator)Class.forName(pkg).getConstructor(String.class, Locale.class, Logger.class).newInstance(logicalName, locale, log);
        }
        catch (Exception ex) {
            throw new CreatingException("Cant' create epp initializator", ex);
        }
    }

    public static ManualKeyInApi createXfsManualKeyInApi(String logicalName, Locale locale, Logger log) throws CreatingException {
        Initializator createInitializator = EppFactory.createXfsInitializator(logicalName, locale, log);
        return createInitializator.getManualKeyInApi();
    }
}

