/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cvd;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.SerialDeviceSection;
import ru.softlogic.hdw.dev.cvd.CvdConfiguration;
import ru.softlogic.hdw.dev.cvd.CvdOptions;
import ru.softlogic.io.serial.SerialPort;

public class CvdSection
extends SerialDeviceSection {
    public static final String MAIN_CAPACITY = "main-capacity";
    public static final String REJECT_CAPACITY = "reject-capacity";
    public static final String TIMEOUT = "timeout";
    public static final String CHECK_BARCODE = "check-barcode";
    public static final String HAS_BARCODE_SCANNER = "has-barcode-scanner";
    private CvdConfiguration cc;

    public CvdSection() {
    }

    public CvdSection(CvdConfiguration cc) {
        this.cc = cc;
    }

    @Override
    public String getKey() {
        return "card-disp";
    }

    @Override
    public Element generate(Document doc) {
        return this.generate(doc, this.cc);
    }

    @Override
    public void parce(Element element) throws ParceException {
        boolean enable = this.getEnable(element);
        String type = this.getDriver(element);
        SerialPort port = this.getSerialPort(element);
        Map<String, String> opt = this.readOptions(element);
        this.cc = new CvdConfiguration(enable, type, port, new CvdOptions(this.readInt(opt, MAIN_CAPACITY), this.readInt(opt, REJECT_CAPACITY, 0), this.readInt(opt, TIMEOUT), this.readBoolean(opt, HAS_BARCODE_SCANNER, false), this.readBoolean(opt, CHECK_BARCODE, false)));
    }

    @Override
    public void generateOptions(Document doc, Element root) {
        CvdOptions co = this.cc.getOptions();
        if (co != null) {
            this.writeOption(doc, root, MAIN_CAPACITY, Integer.toString(co.getMainBoxCapacity()));
            if (co.getRejectBoxCapacity() > 0) {
                this.writeOption(doc, root, REJECT_CAPACITY, Integer.toString(co.getRejectBoxCapacity()));
            }
            this.writeOption(doc, root, TIMEOUT, Integer.toString(co.getRejectTimeout()));
            if (co.isCheckBarcode()) {
                this.writeOption(doc, root, CHECK_BARCODE, Boolean.toString(co.isCheckBarcode()));
            }
            if (co.isHasBarcodeScanner()) {
                this.writeOption(doc, root, HAS_BARCODE_SCANNER, Boolean.toString(co.isHasBarcodeScanner()));
            }
        }
    }

    public CvdConfiguration getConfiguration() {
        return this.cc;
    }
}

