/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cvd;

import ru.softlogic.hdw.dev.cvd.BarcodeHandler;
import ru.softlogic.hdw.dev.cvd.DispenseOperation;
import ru.softlogic.hdw.dev.cvd.SmartCardHandler;

public abstract class BaseDispenseOperation
implements DispenseOperation {
    protected DispenseOperation.State state;
    protected final DispenseOperation.TimeoutAction timeoutAction;
    private final Object sync = new Object();

    public BaseDispenseOperation() {
        this.timeoutAction = DispenseOperation.TimeoutAction.Capture;
    }

    public BaseDispenseOperation(DispenseOperation.TimeoutAction timeoutAction) {
        this.timeoutAction = timeoutAction;
    }

    @Override
    public SmartCardHandler getSmartCardHandler() {
        return null;
    }

    @Override
    public BarcodeHandler getBarcodeHandler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onState(DispenseOperation.State state) {
        if (state == null) {
            throw new NullPointerException("State is null");
        }
        Object object = this.sync;
        synchronized (object) {
            this.state = state;
            this.sync.notifyAll();
        }
    }

    public DispenseOperation.State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispenseOperation.State waitFor() throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            while (this.state == null || this.state == DispenseOperation.State.CardIssued) {
                this.sync.wait();
            }
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispenseOperation.State waitForIssue() throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            while (this.state == null) {
                this.sync.wait();
            }
        }
        return this.state;
    }

    @Override
    public DispenseOperation.TimeoutAction getTimeoutAction() {
        return this.timeoutAction;
    }

    public String toString() {
        return "BaseDispenseOperation{state=" + (Object)((Object)this.state) + ", timeoutAction=" + (Object)((Object)this.timeoutAction) + '}';
    }
}

