/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.crd;

import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.crd.CardReaderDriver;
import ru.softlogic.hdw.dev.crd.CardReaderOptions;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class CardReaderFactory
extends BaseFactory {
    private CardReaderFactory() {
    }

    public static CardReaderDriver createDriver(String type, SerialPort port, CardReaderOptions options, Logger log) throws CreatingException {
        CardReaderFactory.check(type, (Port)port, log);
        if (options == null) {
            throw new CreatingException("Options is not set");
        }
        if ("smartcardio".equals(type)) {
            try {
                TerminalFactory factory = TerminalFactory.getDefault();
                CardTerminals terminals = factory.terminals();
                Class<?> cl = Class.forName("ru.softlogic.hardware.crd.smartcardio.driver.Driver");
                CardReaderDriver cr = (CardReaderDriver)cl.getConstructor(CardTerminals.class, CardReaderOptions.class, Logger.class).newInstance(terminals, options, log);
                return cr;
            }
            catch (ClassNotFoundException ex) {
                throw new CreatingException(ex);
            }
            catch (Exception ex) {
                throw new CreatingException(ex);
            }
        }
        String pkg = "ru.softlogic.hardware.crd." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            CardReaderDriver cr = (CardReaderDriver)cl.getConstructor(SerialPort.class, CardReaderOptions.class, Logger.class).newInstance(port, options, log);
            return cr;
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }

    public static CardReaderDriver createHIDDriver(String type, int vendorId, int productId, String serialNo, CardReaderOptions options, Logger log) throws CreatingException {
        CardReaderFactory.checkType(type);
        CardReaderFactory.checkLogger(log);
        if (options == null) {
            throw new CreatingException("Options is not set");
        }
        String pkg = "ru.softlogic.hardware.crd." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            CardReaderDriver cr = (CardReaderDriver)cl.getConstructor(Integer.class, Integer.class, String.class, CardReaderOptions.class, Logger.class).newInstance(vendorId, productId, serialNo, options, log);
            return cr;
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }

    public static CardReaderDriver createXfsDriver(String logicalName, CardReaderOptions options, Logger log) throws CreatingException {
        try {
            Class<?> cl = Class.forName("ru.softlogic.hardware.crd.xfs.driver.Driver");
            return (CardReaderDriver)cl.getConstructor(String.class, CardReaderOptions.class, Logger.class).newInstance(logicalName, options, log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }
}

