/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.impl.v2;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.BoxedCashDispenserDriver;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.Dispense;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.ValidBoxVisitor;
import ru.softlogic.storage.cash.Box;

class CountsVisitor
extends ValidBoxVisitor {
    private final Map<Denomination, Integer> payout;
    private final int max;
    private final Map<Short, Dispense> counts = new TreeMap<Short, Dispense>();

    public CountsVisitor(Map<Denomination, Integer> payout, int max, BoxedCashDispenserDriver drv, Logger log) {
        super(drv, log);
        this.payout = new HashMap<Denomination, Integer>(payout);
        this.max = max;
    }

    @Override
    protected void onValidBox(Box box, Denomination den, int count) {
        int ability = Math.min(count, this.max);
        Integer needs = this.payout.get(den);
        if (needs != null && needs > 0) {
            if (ability >= needs) {
                this.counts.put(box.getId(), new Dispense(needs, den));
                this.payout.remove(den);
            } else {
                this.counts.put(box.getId(), new Dispense(ability, den));
                this.payout.put(den, needs - ability);
            }
        }
    }

    public Map<Short, Dispense> getCounts() {
        return this.counts;
    }

    public boolean isAvailable() {
        return this.payout.isEmpty();
    }
}

