/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.impl.v2;

import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDescriptor;
import ru.softlogic.hdw.dev.cashdisp.impl.v2.BoxedCashDispenserDriver;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.storage.cash.BaseBox;
import ru.softlogic.storage.cash.BaseStore;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxInfo;
import ru.softlogic.storage.cash.InternalStorage;
import ru.softlogic.storage.cash.Store;
import ru.softlogic.storage.cash.Transfer;
import ru.softlogic.storage.io.Serializator;

public abstract class BoxedCoinDispenserDriver
extends BoxedCashDispenserDriver {
    protected Store mainStore;
    protected InternalStorage storage;
    private final Logger log;

    public BoxedCoinDispenserDriver(DeviceId deviceId, SerialPort port, Serializator serializator, Logger log) {
        super(deviceId, port, serializator, log);
        this.log = log;
        short dc = deviceId.getDeviceClass();
        if (dc != 18) {
            throw new IllegalArgumentException("Wrong device class " + dc);
        }
        this.createStores();
    }

    private void createStores() {
        DeviceId did = this.getDeviceId();
        CashDispenserDescriptor descriptor = this.getDescriptor();
        this.storage = this.createStorage();
        Box[] boxes = new Box[descriptor.getBoxCount()];
        for (short i = 0; i < descriptor.getBoxCount(); i = (short)(i + 1)) {
            boxes[i] = new BaseBox(i, new BoxInfo(3, descriptor.getBoxCapacity(), 99), this.storage, new BoxedCashDispenserDriver.DispenserPhysicalBox(i));
        }
        this.mainStore = new BaseStore("CashDispenser." + did.getNumber(), boxes, this.storage);
    }

    @Override
    protected void beforeDispence() {
    }

    @Override
    public final Store getStore() {
        return this.mainStore;
    }

    @Override
    protected final InternalStorage getStorage() {
        return this.storage;
    }

    @Override
    protected final Transfer processReject(short boxId, Denomination denomination, int rejectCount) {
        this.notifyProblem("Can't process reject operation on coin hopper");
        throw new UnsupportedOperationException("Can't process reject");
    }

    @Override
    protected final Transfer processJamm(short boxId, Denomination denomination, int jammCount) {
        this.notifyProblem("Can't process jamm operation on coin hopper");
        throw new UnsupportedOperationException("Can't process jamm");
    }
}

