/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp.boxed;

import java.util.Map;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hdw.dev.cashdisp.OperationListener;

public class BoxedOperation {
    public static final int TYPE_SUM = 1;
    public static final int TYPE_SET = 2;
    private final int type;
    private final Map<Denomination, Integer> counts;
    private final String currency;
    private final OperationListener listener;

    public BoxedOperation(int type, Map<Denomination, Integer> counts, String currency, OperationListener listener) {
        if (counts == null) {
            throw new NullPointerException("Denomination set is null");
        }
        if (listener == null) {
            throw new NullPointerException("BoxDispenseListener is null");
        }
        if (currency == null) {
            throw new NullPointerException("Currency is null");
        }
        this.counts = counts;
        this.listener = listener;
        this.type = type;
        this.currency = currency;
    }

    public Map<Denomination, Integer> getCounts() {
        return this.counts;
    }

    public OperationListener getListener() {
        return this.listener;
    }

    public int getType() {
        return this.type;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String toString() {
        return "BoxedOperation{type=" + this.type + ", counts=" + this.counts + ", currency=" + this.currency + ", listener=" + this.listener + '}';
    }
}

