/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashdisp;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDescriptor;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDriver;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.storage.io.FileSet;
import ru.softlogic.storage.io.Serializator;
import ru.softlogic.storage.io.SolidSerializator;

public final class CashDispenserFactory
extends BaseFactory {
    private CashDispenserFactory() {
    }

    public static CashDispenserDriver createBillDriver(String type, SerialPort port, File file, Logger log) throws CreatingException {
        return CashDispenserFactory.createDriver("bdm", type, port, file, log);
    }

    public static CashDispenserDriver createCoinDriver(String type, SerialPort port, File file, Logger log) throws CreatingException {
        return CashDispenserFactory.createDriver("cdm", type, port, file, log);
    }

    public static CashDispenserDescriptor createDescriptor(String dclass, String type) throws CreatingException {
        CashDispenserFactory.checkType(type);
        Properties prop = CashDispenserFactory.getParamProperties(dclass, type);
        int features = CashDispenserFactory.getIntParam(prop, "features");
        int boxCount = CashDispenserFactory.getIntParam(prop, "box.count");
        int boxCapacity = CashDispenserFactory.getIntParam(prop, "box.capacity");
        int rejectCapacity = CashDispenserFactory.getIntParam(prop, "reject.capacity");
        int totalCnt = CashDispenserFactory.getIntParam(prop, "payout.count.total");
        int boxCnt = CashDispenserFactory.getIntParam(prop, "payout.count.box");
        return new CashDispenserDescriptor(features, boxCapacity, rejectCapacity, boxCount, boxCnt, totalCnt);
    }

    private static CashDispenserDriver createDriver(String type, String driver, SerialPort port, File file, Logger log) throws CreatingException {
        CashDispenserFactory.check(driver, (Port)port, log);
        String pkg = MessageFormat.format("ru.softlogic.hardware.{0}.{1}.driver.Driver", type, driver);
        SolidSerializator sz = null;
        try {
            sz = new SolidSerializator(new FileSet(file.getAbsolutePath(), type + ".0{0}"));
            return (CashDispenserDriver)Class.forName(pkg).getConstructor(String.class, SerialPort.class, Serializator.class, Logger.class).newInstance(driver, port, sz, log);
        }
        catch (Exception ex) {
            IOUtils.closeQuietly(sz);
            throw new CreatingException(ex);
        }
    }
}

