/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashacc.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.cashacc.PayoutModule;
import ru.softlogic.hdw.dev.cashdisp.BoxState;
import ru.softlogic.hdw.dev.cashdisp.BoxStateListener;
import ru.softlogic.hdw.dev.cashdisp.CashDispenser;
import ru.softlogic.hdw.dev.cashdisp.CashDispenserDescriptor;
import ru.softlogic.hdw.dev.cashdisp.EmptyChannel;
import ru.softlogic.hdw.dev.cashdisp.PayoutBySetOperation;
import ru.softlogic.hdw.dev.cashdisp.PayoutException;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.storage.cash.Store;

public class BasePayoutDispenserModule
extends BaseDevice
implements CashDispenser,
DeviceStateListener {
    private static final String BASE_VERSION = "c2.0.0";
    private final PayoutModule payoutModule;
    private final Logger log;

    public BasePayoutDispenserModule(PayoutModule payoutModule, Logger log) {
        super(new DeviceId(16, "ext-payout", 0), BASE_VERSION, log);
        if (payoutModule == null) {
            throw new NullPointerException("PayoutModule is null");
        }
        this.payoutModule = payoutModule;
        this.log = log;
    }

    @Override
    public void addBoxStateListener(BoxStateListener boxStateListener) {
    }

    @Override
    public void removeBoxStateListener(BoxStateListener boxStateListener) {
    }

    @Override
    public CashDispenserDescriptor getDescriptor() {
        return new CashDispenserDescriptor(0, 80, 0, 1, 80, 80);
    }

    @Override
    public Store getStore() {
        return null;
    }

    @Override
    public void payout(PayoutBySetOperation payout) throws PayoutException {
        if (payout == null) {
            throw new NullPointerException("PayoutBySetOperation is null");
        }
        this.log.info((Object)"========================================================");
        this.log.info((Object)("Begin payout by set, requested counts: " + payout.getCounts()));
        this.payoutModule.payout(payout);
    }

    @Override
    public void onState(DeviceState state) {
        if (state.getState() <= 0) {
            this.updateState(state.getState());
        } else {
            this.updateState(-7);
        }
    }

    @Override
    public Map<Integer, BoxState> getBoxState() {
        return null;
    }

    @Override
    public List<EmptyChannel> getEmptyChannels() {
        return Collections.emptyList();
    }
}

