/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cashacc.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.DefaultComparator;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hardware.currency.WrongNominalException;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.cashacc.CashAcceptor;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDevice;
import ru.softlogic.hdw.dev.cashacc.CashAcceptorDriver;
import ru.softlogic.hdw.dev.cashacc.CashInOperation;
import ru.softlogic.hdw.dev.cashacc.CashInOperationListener;
import ru.softlogic.hdw.dev.cashacc.DriverControl;
import ru.softlogic.hdw.dev.cashacc.EventListener;
import ru.softlogic.hdw.dev.cashacc.PayoutModule;
import ru.softlogic.hdw.dev.cashacc.StackListener;
import ru.softlogic.hdw.handling.CashInfo;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.HdwMsg;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;
import ru.softlogic.storage.cash.BoxInfo;

public abstract class BaseCashAcceptorDriver
extends BaseDevice
implements CashAcceptorDevice,
CashAcceptorDriver,
Runnable,
CashInOperationListener {
    private static final String BASE_VERSION = "c2.1.1";
    private final DeviceId deviceId;
    private final SerialPort port;
    private final List<Thread> threads;
    private boolean flagEnable;
    private boolean safeState;
    private long lastActivityChange;
    private CashInOperation operation;
    private final Logger log;
    private final Object eSync = new Object();
    private final Object sSync = new Object();
    private final Set<StackListener> stackListeners;
    private final Set<EventListener> eventListeners;
    private Map<String, SortedSet<Denomination>> dens;
    private final String currency;
    private Set<String> currencies;
    private SortedSet<Denomination> fullDens;
    private boolean extStack;
    private long accTime;

    public BaseCashAcceptorDriver(DeviceId deviceId, SerialPort port, String currency, Logger log) {
        super(deviceId, BASE_VERSION, log);
        this.deviceId = deviceId;
        this.port = port;
        this.currency = currency;
        this.log = log;
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(" + deviceId.getType() + ")"));
        this.stackListeners = new HashSet<StackListener>();
        this.eventListeners = new HashSet<EventListener>();
        this.dens = new HashMap<String, SortedSet<Denomination>>();
        this.safeState = true;
        this.fullDens = Collections.unmodifiableSortedSet(new TreeSet());
        this.currencies = Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public boolean isEquipped(CashAcceptor.Module module) {
        return false;
    }

    @Override
    public String getMainCurrency() {
        return this.currency;
    }

    @Override
    public Set<String> getCurrencies() {
        return this.currencies;
    }

    @Override
    public SortedSet<Denomination> getDenominations(String currency) {
        SortedSet<Denomination> res = this.dens.get(currency);
        return res != null ? Collections.unmodifiableSortedSet(res) : new TreeSet<Denomination>();
    }

    @Override
    public SortedSet<Denomination> getDenominations() {
        return this.fullDens;
    }

    @Override
    public void removeStackListener(StackListener stackListener) {
        if (stackListener == null) {
            throw new NullPointerException("StackListener is null");
        }
        this.stackListeners.remove(stackListener);
    }

    @Override
    public void addStackListener(StackListener stackListener) {
        if (stackListener == null) {
            throw new NullPointerException("StackListener is null");
        }
        this.stackListeners.add(stackListener);
    }

    @Override
    public void addEventListener(EventListener eventListener) {
        if (eventListener == null) {
            throw new NullPointerException("EventListener is null");
        }
        this.eventListeners.add(eventListener);
    }

    @Override
    public void removeEventListener(EventListener eventListener) {
        if (eventListener == null) {
            throw new NullPointerException("EventListener is null");
        }
        this.eventListeners.remove(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable(CashInOperation operation) {
        if (operation == null) {
            throw new NullPointerException("CashInOperation is null");
        }
        this.log.info((Object)("========================================================" + (operation.getToken() != null ? operation.getToken() : "")));
        this.safeState = true;
        Object object = this.eSync;
        synchronized (object) {
            if (this.flagEnable) {
                throw new IllegalStateException("Device already enabled");
            }
            this.flagEnable = true;
            this.operation = operation;
            operation.addOperationListener(this);
            this.notifySleep();
        }
        this.notifyEvent(0);
        this.updateLastActivityChange();
        this.log.info((Object)"Enable done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() {
        this.log.info((Object)"Disable device");
        Object object = this.eSync;
        synchronized (object) {
            this.flagEnable = false;
            this.updateLastActivityChange();
        }
        this.notifySleep();
        this.log.info((Object)"Disable done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitSafeState() throws InterruptedException {
        if (this.flagEnable) {
            throw new IllegalStateException("Wrong state, cash acceptor must be disabled");
        }
        this.log.info((Object)"Wait safe state");
        Object object = this.sSync;
        synchronized (object) {
            if (!this.safeState) {
                this.sSync.wait(4000L);
            }
        }
        this.updateLastActivityChange();
        if (!this.safeState) {
            this.notifyProblem("Safe state not appear");
        }
        if (this.operation != null) {
            this.operation.removeOperationListener(this);
        }
        this.operation = null;
        this.log.info((Object)"Wait safe done");
    }

    @Override
    public final List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public CashAcceptorDevice getCashAcceptor() {
        return this;
    }

    @Override
    public void reinit() {
    }

    protected void notifyFraud(int markerId) {
        this.notifyProblem("Notify fraud, markerId: " + markerId + ", " + HdwMsg.getFraudMarker(markerId));
        if (this.operation != null) {
            this.operation.onFraudMarker(markerId);
        }
    }

    protected void notifyEvent(int eventId) {
        if (eventId == 1) {
            this.accTime = System.currentTimeMillis();
        }
        for (EventListener el : this.eventListeners) {
            el.onEvent(eventId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySafeState(boolean safe) {
        if (this.safeState != safe) {
            this.log.info((Object)("Safe changed: " + safe));
            this.safeState = safe;
            Object object = this.sSync;
            synchronized (object) {
                this.sSync.notifyAll();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.flagEnable;
    }

    @Override
    public final void run() {
        this.log.info((Object)"Start cash acceptor driver");
        this.log.info((Object)("Port: " + SerialFmt.format((SerialPort)this.port)));
        this.log.info((Object)("Driver: " + this.deviceId.getType() + ", number: " + this.deviceId.getNumber()));
        this.updateLastActivityChange();
        try {
            this._run();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable ex) {
            this.updateState(-7);
        }
        this.beforeStop();
        this.port.close();
        this.log.info((Object)"Stop thread");
    }

    protected void beforeStop() {
    }

    protected Denomination getBill(String curr, int nominal) {
        return this.getDenomination(curr, nominal, 0);
    }

    protected Denomination getCoin(String curr, int nominal) {
        return this.getDenomination(curr, nominal, 1);
    }

    protected Denomination getDenomination(String curr, int nominal, int type) {
        try {
            return Cash.getDenomination(curr, nominal, type);
        }
        catch (WrongNominalException ex) {
            this.notifyWrongNominal(curr, nominal);
        }
        catch (CashProfileException ex) {
            this.notifyWrongCurrency(curr);
        }
        return null;
    }

    private void notifyWrongCurrency(String curr) {
        this.notifyProblemOnce("Unknown currency: " + curr);
    }

    private void notifyWrongNominal(String curr, int nominal) {
        this.notifyProblemOnce("Unknown nominal " + nominal + " for currency: " + curr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canStack(Denomination d) {
        Object object = this.eSync;
        synchronized (object) {
            if (!this.flagEnable) {
                this.log.info((Object)"Device disable, reject");
                this.notifyEvent(8);
                return false;
            }
            if (d == null) {
                this.log.info((Object)"Denomination is not found, reject");
                this.notifyEvent(8);
                return false;
            }
            if (!d.getCurrency().equals(this.operation.getCurrency())) {
                this.log.info((Object)("Wrong currency, expect=" + this.operation.getCurrency() + ", obtained=" + d.getCurrency()));
                this.notifyEvent(8);
                return false;
            }
            if (!this.operation.canAccept(this.deviceId, d)) {
                this.log.info((Object)("Denomination reject by operation: " + d));
                this.notifyEvent(8);
                return false;
            }
            return true;
        }
    }

    protected void stack(Denomination d) {
        this.stack(d, 0);
    }

    protected void stackToPayout(Denomination d) {
        this.stack(d, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stack(Denomination d, int dest) {
        long to = this.getNormalAccTimeout();
        if (to > 0L && System.currentTimeMillis() - this.accTime < to) {
            this.notifyFraud(4);
        }
        this.log.info((Object)("Stack: " + d + ", dest=" + (dest == 0 ? "MAIN" : "PAYOUT")));
        Iterator<StackListener> iterator = this.eSync;
        synchronized (iterator) {
            if (this.operation != null) {
                this.operation.onAccept(this.deviceId, d);
            } else {
                this.notifyProblem("Lost " + d + ", from disable: " + this.getIntervalActivityAsStr());
            }
        }
        for (StackListener sl : this.stackListeners) {
            sl.onStack(d, dest);
        }
    }

    protected String getOperationCurrency() {
        if (this.operation != null) {
            return this.operation.getCurrency();
        }
        this.notifyProblemOnce("Illegal state on request currency");
        return null;
    }

    protected DeviceInfo createDeviceInfo(String vendor, String proto, String drvVersion, Set<Denomination> denominations) {
        Integer size = null;
        return this.createDeviceInfo(vendor, proto, drvVersion, denominations, size);
    }

    protected DeviceInfo createDeviceInfo(String vendor, String proto, String drvVersion, Set<Denomination> denominations, Integer boxSize) {
        HashMap<Integer, BoxInfo> bis = new HashMap<Integer, BoxInfo>();
        bis.put(0, new BoxInfo(0, boxSize, 13));
        return this.createDeviceInfo(vendor, proto, drvVersion, denominations, bis);
    }

    protected DeviceInfo createDeviceInfo(String vendor, String proto, String drvVersion, Set<Denomination> denominations, Map<Integer, BoxInfo> boxInfos) {
        this.updateDenominations(denominations);
        DeviceInfo di = new DeviceInfo(this.deviceId.getDeviceClass(), this.deviceId.getType());
        di.setPort(SerialFmt.format((SerialPort)this.port));
        di.setVendor(vendor);
        di.setProto(proto);
        di.setDriver(drvVersion);
        CashInfo ci = new CashInfo(this.getCurrencies(), this.getDenominations(), Collections.unmodifiableMap(boxInfos));
        di.setCashInfo(ci);
        return di;
    }

    private void updateDenominations(Set<Denomination> denominations) {
        if (denominations == null) {
            return;
        }
        TreeSet<Denomination> f = new TreeSet<Denomination>(new DefaultComparator());
        f.addAll(denominations);
        this.fullDens = Collections.unmodifiableSortedSet(f);
        HashMap<String, SortedSet<Denomination>> res = new HashMap<String, SortedSet<Denomination>>();
        for (Denomination den : denominations) {
            TreeSet<Denomination> set = (TreeSet<Denomination>)res.get(den.getCurrency());
            if (set == null) {
                set = new TreeSet<Denomination>(new DefaultComparator());
                res.put(den.getCurrency(), set);
            }
            set.add(den);
        }
        this.dens = res;
        this.updateCurrencies(this.dens.keySet());
    }

    private void updateCurrencies(Set<String> currencies) {
        this.log.info((Object)("Update currencies: " + currencies));
        TreeSet<String> ts = new TreeSet<String>();
        for (String curr : currencies) {
            try {
                ts.add(Cash.correctCode(curr));
            }
            catch (CashProfileException ex) {
                this.log.info((Object)("Wrong currency: " + curr + ", cause=" + ex.getMessage()));
            }
        }
        this.currencies = Collections.unmodifiableSortedSet(ts);
    }

    protected String denominationsAsStr(Set<Denomination> denominations) {
        StringBuilder str = new StringBuilder();
        for (Denomination d : denominations) {
            str.append(SumFormatter.asStr(d));
            str.append(" ");
        }
        return str.toString().trim();
    }

    @Override
    public DriverControl getDriverControl() {
        return null;
    }

    @Override
    public PayoutModule getPayoutApi() {
        return null;
    }

    @Override
    public void onChangeKeeper() {
        this.extStack = true;
    }

    protected boolean isKeeperChange() {
        if (this.extStack) {
            this.log.info((Object)"Keeper change");
            this.extStack = false;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<Integer, Denomination> loadTable(String curr) {
        TreeMap<Integer, Denomination> res = new TreeMap<Integer, Denomination>();
        InputStream is = null;
        String path = "table_" + curr + ".properties";
        try {
            is = this.getClass().getResourceAsStream(path);
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                for (String str : prop.stringPropertyNames()) {
                    String valStr = prop.getProperty(str);
                    try {
                        int key = Integer.parseInt(str);
                        int val = Integer.parseInt(valStr);
                        res.put(key, Cash.getBill(curr, val));
                    }
                    catch (Exception ex) {
                        this.notifyProblemOnce("Error on parce " + path + ": " + ex.getMessage());
                    }
                }
            } else {
                this.log.error((Object)("Resource is not found: " + path));
            }
        }
        catch (IOException ex) {
            this.notifyProblemOnce("Error on parce " + path + ": " + ex.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.log.info((Object)"Table: ");
        Iterator iterator = res.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.log.info((Object)("    " + key + "->" + res.get(key)));
        }
        this.log.info((Object)"--");
        return res;
    }

    protected void notifyConnErrorAndReset(Exception ex) {
        this.notifySafeState(true);
        this.onConnError(ex);
    }

    protected abstract void _run() throws InterruptedException;

    protected long getNormalAccTimeout() {
        return 2000L;
    }

    private void updateLastActivityChange() {
        this.lastActivityChange = System.currentTimeMillis();
    }

    private String getIntervalActivityAsStr() {
        long itv = System.currentTimeMillis() - this.lastActivityChange;
        return String.format("%.2f s", (double)itv * 1.0 / 1000.0);
    }
}

