/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceClass;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.utils.BU;

public class Hardware {
    public static final String PARAM_INIT = "init";
    private static final Logger LOG = Logger.getLogger(Hardware.class);
    private static File firmwarePath = new File(".");
    private static final Properties PROP = new Properties();

    private Hardware() {
    }

    public static String getVersion() {
        return "3.8.3";
    }

    public static List<DeviceInfo> lookupUsbDevices() {
        LinkedList<DeviceInfo> dis = new LinkedList<DeviceInfo>();
        CardTerminals cts = TerminalFactory.getDefault().terminals();
        try {
            List<CardTerminal> list = cts.list();
            if (!list.isEmpty()) {
                DeviceInfo di = new DeviceInfo(24, "softlogic.ru");
                di.setModel(list.get(0).getName());
                String str = "";
                for (CardTerminal ct : list) {
                    str = str + (str.isEmpty() ? "" : ",") + ct.getName();
                }
                di.setInfo(str);
                dis.add(di);
            }
        }
        catch (CardException cardException) {
            // empty catch block
        }
        return dis;
    }

    public static File getFirmwarePath() {
        return firmwarePath;
    }

    public static void setFirmwarePath(File firmwarePath) {
        if (firmwarePath == null) {
            throw new NullPointerException("Path is null");
        }
        Hardware.firmwarePath = firmwarePath;
    }

    public static boolean ioDebugEnable() {
        return System.getProperty("io-debug") != null;
    }

    public static byte[] getBytesParam(DeviceId did, String param, byte[] def) {
        String value = PROP.getProperty(Hardware.getParamKey(did, param));
        return BU.isHexString((String)value) ? BU.convertFromHex((String)value) : def;
    }

    public static byte[] getBytesParam(DeviceId did, String param) {
        return Hardware.getBytesParam(did, param, null);
    }

    private static String getParamKey(DeviceId did, String param) {
        if (did == null) {
            throw new IllegalArgumentException("DeviceId is null");
        }
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Param is not set");
        }
        return DeviceClass.getCode(did.getDeviceClass()) + "." + did.getType() + "." + param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String path = System.getProperty("hardware.configuration");
        File hdwconf = new File(path != null && path.isEmpty() ? path : "./res/hardware.properties");
        if (hdwconf.canRead()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(hdwconf);
                PROP.load(is);
            }
            catch (IOException ex) {
                try {
                    LOG.error((Object)("Error on load hardware properties from " + hdwconf.getAbsolutePath()), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

