/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.io.Port;

public abstract class BaseFactory {
    public static final String FEATURES = "features";

    public static Properties getProperties(String path) throws CreatingException {
        InputStream is;
        block5: {
            is = null;
            is = BaseFactory.class.getResourceAsStream(path);
            if (is == null) break block5;
            Properties prop = new Properties();
            prop.load(is);
            Properties properties = prop;
            BaseFactory.closeQuetly(is);
            return properties;
        }
        try {
            try {
                throw new CreatingException("Not found: " + path);
            }
            catch (IOException ex) {
                throw new CreatingException(ex);
            }
        }
        catch (Throwable throwable) {
            BaseFactory.closeQuetly(is);
            throw throwable;
        }
    }

    public static Properties getPropertiesQuetly(String path) {
        try {
            return BaseFactory.getProperties(path);
        }
        catch (CreatingException ex) {
            return null;
        }
    }

    public static Properties getParamProperties(String deviceClass, String deviceType) throws CreatingException {
        BaseFactory.checkType(deviceType);
        return BaseFactory.getProperties("/ru/softlogic/hardware/" + deviceClass + "/" + deviceType.toLowerCase() + "/params.properties");
    }

    public static Properties getParamPropertiesQuetly(String deviceClass, String deviceType) {
        BaseFactory.checkType(deviceType);
        try {
            return BaseFactory.getParamProperties(deviceClass, deviceType.toLowerCase());
        }
        catch (CreatingException ex) {
            return null;
        }
    }

    public static int getIntParam(Properties prop, String key) throws CreatingException {
        String value = prop.getProperty(key);
        BaseFactory.checkExist(value, key);
        BaseFactory.checkMatches(value, "\\d{1,7}", key);
        return Integer.parseInt(value);
    }

    public static int getHexParam(Properties prop, String key) throws CreatingException {
        String value = prop.getProperty(key);
        BaseFactory.checkExist(value, key);
        BaseFactory.checkMatches(value, "[0-9a-fA-F]{1,4}", key);
        return Integer.parseInt(value, 16);
    }

    public static int getFeatures(Properties prop) throws CreatingException {
        return BaseFactory.getHexParam(prop, FEATURES);
    }

    public static String getString(Properties prop, String key) throws CreatingException {
        String val = prop.getProperty(key);
        BaseFactory.checkExist(val, key);
        return val;
    }

    protected static int getFeaturesQuetly(String deviceClass, String deviceType) throws CreatingException {
        BaseFactory.checkType(deviceType);
        Properties prop = BaseFactory.getParamPropertiesQuetly(deviceClass, deviceType);
        return prop != null ? BaseFactory.getFeatures(prop) : 0;
    }

    public static final void closeQuetly(Closeable ... closes) {
        if (closes != null) {
            for (Closeable c : closes) {
                if (c == null) continue;
                try {
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected static void checkType(String type) {
        if (type == null || type.isEmpty()) {
            throw new NullPointerException("Type is not set");
        }
    }

    protected static void checkPort(Port port) {
        if (port == null) {
            throw new NullPointerException("Port is not set");
        }
    }

    protected static void checkLogger(Logger log) {
        if (log == null) {
            throw new NullPointerException("Logger is not set");
        }
    }

    protected static void check(String type, Port port) {
        BaseFactory.checkType(type);
        BaseFactory.checkPort(port);
    }

    protected static void check(String type, Port port, Logger log) {
        BaseFactory.checkType(type);
        BaseFactory.checkPort(port);
        BaseFactory.checkLogger(log);
    }

    private static void checkExist(String val, String key) throws CreatingException {
        if (val == null) {
            throw new CreatingException("Param '" + key + "' is not found");
        }
    }

    private static void checkMatches(String val, String regex, String key) throws CreatingException {
        if (!val.matches(regex)) {
            throw new CreatingException("Param '" + key + "' with value=" + val + " is not matches to regex=" + regex);
        }
    }
}

