/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.lookup.DeviceDescription;
import ru.softlogic.hardware.search.NotFoundException;
import ru.softlogic.hardware.search.SerialSearchable;
import ru.softlogic.hardware.search.SimpleSerialSearchable;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;

public abstract class BaseSearchable
extends SimpleSerialSearchable
implements SerialSearchable {
    protected static final int CAN_SEARCH_ON_SERIAL = 1;
    protected static final int CAN_SEARCH_ON_USB2COM = 2;
    protected static final int CAN_SEARCH_ON_ACM = 4;
    protected static final SerialParams[] NO_SERIAL_PARAMS = new SerialParams[0];
    protected Logger log = Logger.getLogger((String)"silent");

    @Override
    public final DeviceDescription search(SerialPort port) throws NotFoundException {
        if (port != null) {
            return this._search(port);
        }
        throw new NotFoundException("Bad params");
    }

    protected abstract DeviceDescription _search(SerialPort var1) throws NotFoundException;

    @Override
    public boolean canSearch(SerialPort port) {
        return true;
    }

    protected boolean canSearch(SerialPort port, int mask) {
        if (port == null || port.getName() == null) {
            return false;
        }
        String name = port.getName();
        if (name.startsWith("COM")) {
            return true;
        }
        boolean res = true;
        if (name.startsWith("/dev/ttyUSB") || name.startsWith("/dev/serial/by-id/") || name.startsWith("/dev/serial/by-path/")) {
            res &= (mask & 2) != 0;
        } else if (name.startsWith("/dev/ttyACM")) {
            res &= (mask & 4) != 0;
        } else if (name.startsWith("/dev/ttyS") || name.startsWith("/dev/ttyD") || name.startsWith("/dev/ttyF")) {
            res &= (mask & 1) != 0;
        }
        return res;
    }

    protected boolean isDriverExist(String cat, String dtype) {
        try {
            Class.forName("ru.softlogic.hardware." + cat + "." + dtype + ".driver.Driver");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeviceDescription createDescriptor(String cat, String dtype) {
        InputStream is = null;
        try {
            is = BaseSearchable.class.getResourceAsStream("ru/softlogic/hardware/" + cat + "/" + dtype + "/desc");
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                DeviceDescription deviceDescription = new DeviceDescription(cat, dtype, prop.getProperty("name"), prop.getProperty("description"));
                return deviceDescription;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new DeviceDescription(cat, dtype, dtype.toUpperCase(Locale.ENGLISH), "");
    }

    @Override
    public SerialSearchable getSerialSearchable() {
        return this;
    }
}

