/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.lookup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import ru.softlogic.hardware.lookup.DeviceDescription;

abstract class LookupEngine {
    LookupEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void process(String path, Set<DeviceDescription> devices) {
        File file = new File(path);
        if (!file.isFile()) {
            file = new File("./dist/", path);
        }
        if (file.isFile()) {
            JarFile jf = null;
            try {
                jf = new JarFile(file);
                Enumeration<JarEntry> en = jf.entries();
                while (en.hasMoreElements()) {
                    JarEntry je = en.nextElement();
                    if (!je.getName().matches("^ru/softlogic/hardware/.*/.*/(driver/)?(Driver|Api|Factory).*$")) continue;
                    String[] content = je.getName().substring("ru/softlogic/hardware/".length()).split("/");
                    LookupEngine.processNewFormat2(jf, content[0], content[1], devices);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (jf != null) {
                    try {
                        jf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processNewFormat2(JarFile jf, String cl, String type, Set<DeviceDescription> devices) {
        InputStreamReader isr = null;
        try {
            InputStream is;
            JarEntry je = jf.getJarEntry("ru/softlogic/hardware/" + cl + "/" + type + "/desc");
            if (je != null && (is = jf.getInputStream(je)) != null) {
                Properties prop = new Properties();
                isr = new InputStreamReader(is, "UTF-8");
                prop.load(isr);
                devices.add(new DeviceDescription(cl, type, prop.getProperty("name"), prop.getProperty("description"), Boolean.parseBoolean(prop.getProperty("hidden", "false"))));
                return;
            }
            devices.add(new DeviceDescription(cl, type, type.toUpperCase(Locale.ENGLISH), ""));
        }
        catch (IOException iOException) {
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static boolean canSearch(String path) {
        return path.matches("^.*device-.*-driver\\.jar$") || path.matches("^.*softlogic-hardware-.*\\.jar$");
    }
}

