/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency.add;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;

public class SingleCurrencyKeeper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String currency;
    private final Map<Denomination, Integer> map = new HashMap<Denomination, Integer>();

    public SingleCurrencyKeeper(String currency) {
        if (currency == null) {
            throw new NullPointerException("Curreny is null");
        }
        if (currency.trim().length() != 3) {
            throw new NullPointerException("Wrong currency code: " + currency);
        }
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Sum getSum() {
        int value = 0;
        for (Denomination den : this.map.keySet()) {
            int cnt = this.map.get(den);
            value += den.getNominal() * cnt;
        }
        return new Sum(value, this.currency);
    }

    public void add(Denomination denomination) {
        this.add(denomination, 1);
    }

    public void add(Denomination denomination, int count) {
        if (denomination == null) {
            throw new NullPointerException("Denomination is null");
        }
        if (!this.currency.equals(denomination.getCurrency())) {
            throw new IllegalArgumentException("Wrong denomination currency");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be positive. Value is " + count);
        }
        Integer cnt = this.map.get(denomination);
        if (cnt == null) {
            this.map.put(denomination, count);
        } else {
            this.map.put(denomination, cnt + count);
        }
    }

    public Map<Denomination, Integer> getDenominations() {
        return Collections.unmodifiableMap(this.map);
    }
}

