/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfile;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;

public class SumFormatter {
    public static String asStr(Sum sum) {
        if (sum == null) {
            return "-";
        }
        return SumFormatter.asStr(sum.getValue(), sum.getCurrency(), null);
    }

    public static String asStr(Denomination denomination) {
        if (denomination == null) {
            return "-";
        }
        return SumFormatter.asStr(denomination.getNominal(), denomination.getCurrency(), null);
    }

    public static String asStr(Sum sum, String country) {
        if (sum == null) {
            return "-";
        }
        return SumFormatter.asStr(sum.getValue(), sum.getCurrency(), country);
    }

    public static String asStr(Denomination denomination, String country) {
        if (denomination == null) {
            return "-";
        }
        return SumFormatter.asStr(denomination.getNominal(), denomination.getCurrency(), country);
    }

    public static String asStr(int sum, String currency, String country) {
        try {
            CashProfile cp = Cash.getCashProfile(currency);
            Locale l = country == null ? cp.getLocale() : Cash.getLocale(country);
            String template = cp.getTemplate();
            if (template != null) {
                MessageFormat f = new MessageFormat(template, l);
                return f.format(new Object[]{(double)sum * 1.0 / (double)cp.getScale()});
            }
            return NumberFormat.getCurrencyInstance(l).format((double)sum / 100.0);
        }
        catch (Throwable ex) {
            return NumberFormat.getCurrencyInstance(Locale.getDefault()).format((double)sum / 100.0);
        }
    }

    public static String asStr(int sum, String currency, String country, boolean dropZeros) {
        String val = SumFormatter.asStr(sum, currency, null);
        return dropZeros ? val.replace(".00", "") : val;
    }
}

