/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.currency;

import java.util.Objects;

public class Sum
implements Comparable<Sum> {
    private final int value;
    private final String currency;

    public Sum(int value, String currency) {
        if (value < 0) {
            throw new IllegalArgumentException("Value must be great or equals 0, but there " + value + " " + currency);
        }
        if (currency == null) {
            throw new NullPointerException("Currency in set is null");
        }
        if (currency.length() != 3) {
            throw new IllegalArgumentException("Wrong currency code: " + currency);
        }
        this.value = value;
        this.currency = currency;
    }

    public int getValue() {
        return this.value;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Sum add(Sum oth) {
        this.check(oth);
        return new Sum(this.value + oth.value, this.currency);
    }

    public Sum sub(Sum oth) {
        this.check(oth);
        return new Sum(this.value - oth.value, this.currency);
    }

    public Sum mul(int multiplier) {
        return new Sum(this.value * multiplier, this.currency);
    }

    public Sum mul(double multiplier) {
        return new Sum((int)Math.round((double)this.value * multiplier), this.currency);
    }

    public Sum div(double divider) {
        return new Sum((int)Math.round((double)this.value / divider), this.currency);
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    @Override
    public int compareTo(Sum o) {
        this.check(o);
        return this.value - o.value;
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + this.value;
        hash = 11 * hash + Objects.hashCode(this.currency);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sum other = (Sum)obj;
        if (this.value != other.value) {
            return false;
        }
        return Objects.equals(this.currency, other.currency);
    }

    public String toString() {
        return "Sum{value=" + this.value + ", currency=" + this.currency + '}';
    }

    private void check(Sum sum) {
        if (sum == null) {
            throw new NullPointerException("Sum is null");
        }
        if (!this.currency.equals(sum.getCurrency())) {
            throw new IllegalArgumentException("Wrong currency, expected: " + this.currency + ", obtained: " + sum.getCurrency());
        }
    }
}

